<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$wa  = $document->getWebAssetManager();

$returnText = '';
         
if ((int)$currentpath->kmllayertype == 0
  ||(int)$currentpath->kmllayertype == 1
  ||(int)$currentpath->kmllayertype == 2)
{
    if (isset($currentpath->kmllayertype) && $currentpath->kmllayer != "") 
    {          
        if (isset($currentpath->override_styles) && (int)$currentpath->override_styles == 0)
        {
            $path_styles = '{}';
        }
        else
        {
            $path_styles = '{'."\n";
            $path_styles .= '    style: function(feature) {'."\n";
            $path_styles .= '        return { '."\n";
            $path_styles .= '           color: "'.$currentpath->color.'"'."\n";
            $path_styles .= '          ,opacity: '.$currentpath->opacity."\n";
            $path_styles .= '          ,weight: '.$currentpath->weight."\n";

            if ($currentpath->fillcolor != "")
            {
                    $path_styles .= '          ,fillColor: "'.$currentpath->fillcolor.'"'."\n";
            }
            if ($currentpath->fillopacity != "")
            {
                    $path_styles .= '          ,fillOpacity: '.$currentpath->fillopacity."\n";
            }
            $path_styles .= '        };'."\n";
            $path_styles .= '    }'."\n";
            $path_styles .= '}';
        }

        if ((int)$currentpath->kmllayertype == 0
          ||(int)$currentpath->kmllayertype == 1)
        {
                
            $returnText .= 'var kmlLayerStyle'.$currentpath->id.' = L.geoJson(null, '.$path_styles.');'."\n";
 
            if ((int)$currentpath->kmllayertype == 0)
            {
                $returnText .= 'var kmlLayer'.$currentpath->id.' = omnivore.kml(\''.$currentpath->kmllayer.'\', null, kmlLayerStyle'.$currentpath->id.')' ."\n";
            }
            else if ((int)$currentpath->kmllayertype == 1)
            {
                $returnText .= 'var kmlLayer'.$currentpath->id.' = omnivore.gpx(\''.$currentpath->kmllayer.'\', null, kmlLayerStyle'.$currentpath->id.')' ."\n";
            }            
        }
        else 
        {
            
            $returnText .= 'var kmlLayergeoJSON'.$currentpath->id.' = JSON.parse(loadTextFileAjaxSync(\''.$currentpath->kmllayer.'\', "application/json"));'."\n";
            $returnText .= 'var kmlLayer'.$currentpath->id.' =  L.geoJson(kmlLayergeoJSON'.$currentpath->id.', '.$path_styles.')'."\n";

        }


        if ((int)$currentpath->kmllayertype == 0
          ||(int)$currentpath->kmllayertype == 1)
        {
            $returnText .= '.on(\'ready\', function() {' ."\n";
        }
        else
        {
            $returnText .= '.on(\'add\', function() {' ."\n";
        }
        if (isset($currentpath->showtype) && (int)$currentpath->showtype == 0)
        {
            $returnText .= 'map'.$mapDivSuffix.'.fitBounds(kmlLayer'.$currentpath->id.'.getBounds());' ."\n";
        }
        if (isset($currentpath->suppressinfowindows) && (int)$currentpath->suppressinfowindows == 0)
        {
            $returnText .= '  kmlLayer'.$currentpath->id.'.eachLayer(function(layer) {' ."\n";
            $returnText .= '  if (typeof layer.feature.properties.popupContent !== \'undefined\' && layer.feature.properties.popupContent != "")'."\n";
            $returnText .= '  {'."\n";
            if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
            {
                $returnText .= '    layer.bindPopup(L.popup('.$scripttext_pp_main_style.').setContent(layer.feature.properties.popupContent));'."\n";
            }
            else
            {
                $returnText .= '    layer.bindPopup(layer.feature.properties.popupContent);' ."\n"; 
            }
            $returnText .= '  }'."\n";
            $returnText .= '  else'."\n";
            $returnText .= '  {'."\n";
            if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
            {
                $returnText .= '    layer.bindPopup(L.popup('.$scripttext_pp_main_style.').setContent(layer.feature.properties.name));'."\n";
            }
            else
            {
                $returnText .= '    layer.bindPopup(layer.feature.properties.name);' ."\n"; 
            }
            $returnText .= '  }'."\n";

            $returnText .= '  });' ."\n";
        }

        $returnText .= '});' ."\n";

        $returnText .= '  kmlLayer'. $currentpath->id.'.zhomPathID = '. $currentpath->id.';' ."\n";
        $returnText .= '  kmlLayer'. $currentpath->id.'.zhomObjectType = '. $currentpath->objecttype.';' ."\n";
        $returnText .= '  kmlLayer'. $currentpath->id.'.zhomInfowinContent = contentPathString'. $currentpath->id.';' ."\n";    
        $returnText .= '  kmlLayer'. $currentpath->id.'.zhomTitle = "'.str_replace('\\', '/', str_replace('"', '\'\'', $currentpath->title)).'";' ."\n";    

        if ((int)$currentpath->objecttype == 1)
        {
            if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
            {
                $returnText .= '  kmlLayer'. $currentpath->id.'.zhomHoverChangeColor = 1;' ."\n";
                $returnText .= '  kmlLayer'. $currentpath->id.'.zhomStrokeColor = "'. $currentpath->color.'";' ."\n";
             }
            else
            {
                $returnText .= '  kmlLayer'. $currentpath->id.'.zhomHoverChangeColor = 0;' ."\n";
            }
        }
        else
        {
            if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
            {
                $returnText .= '  kmlLayer'. $currentpath->id.'.zhomHoverChangeColor = 1;' ."\n";
                $returnText .= '  kmlLayer'. $currentpath->id.'.zhomStrokeColor = "'. $currentpath->color.'";' ."\n";
                $returnText .= '  kmlLayer'. $currentpath->id.'.zhomFillColor = "'. $currentpath->fillcolor.'";' ."\n";
            }
            else
            {
                $returnText .= '  kmlLayer'. $currentpath->id.'.zhomHoverChangeColor = 0;' ."\n";
            }
        }

        // Mouse hover - begin
        if (isset($map->hovermarker) && ((int)$map->hovermarker !=0))    
        {
                if ($currentpath->hoverhtml != "")
                {
                    if (isset($map->useajax) && (int)$map->useajax != 0)
                    {
                            $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(kmlLayer'. $currentpath->id.');'."\n";
                    }
                    else
                    {                                                                                
                        if ((int)$map->hovermarker != 0)
                        {
                                $returnText .= '  kmlLayer'. $currentpath->id.'.bindTooltip(hoverStringPath'. $currentpath->id.$fv_hover_marker_options.');'."\n";
                                $returnText .= '  kmlLayer'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                
                                if (isset($currentpath->override_styles) && (int)$currentpath->override_styles == 0)
                                {
                                    // do not apply any style
                                }
                                else
                                {
                                    if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                    {
                                            $returnText .= '    kmlLayer'. $currentpath->id.'.setStyle({' ."\n";    
                                            if ($currentpath->hover_color != "")
                                            {
                                                    $returnText .= '     color: "'.$currentpath->hover_color.'"'."\n";
                                            }        
                                            if ((int)$currentpath->objecttype != 1)
                                            {
                                                if ($currentpath->hover_fillcolor != "")
                                                {
                                                        if ($currentpath->hover_color != "")
                                                        {
                                                                $returnText .= '    ,';
                                                        }                    
                                                        else
                                                        {
                                                                $returnText .= '     ';
                                                        }
                                                        $returnText .= 'fillColor: "'.$currentpath->hover_fillcolor.'"'."\n";
                                                }                                                                    
                                            }
                                            $returnText .= '      });' ."\n";
                                    }                                    
                                }
                                $returnText .= '    kmlLayer'. $currentpath->id.'.openTooltip();' ."\n";

                                $returnText .= '  });' ."\n";

                                $returnText .= '  kmlLayer'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                if (isset($currentpath->override_styles) && (int)$currentpath->override_styles == 0)
                                {
                                    // do not apply any style
                                }
                                else
                                {
                                    if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                                    {
                                            $returnText .= '    kmlLayer'. $currentpath->id.'.setStyle({' ."\n";    
                                            if ($currentpath->hover_color != "")
                                            {
                                                    $returnText .= '     color: "'.$currentpath->color.'"'."\n";
                                            }        
                                            if ((int)$currentpath->objecttype != 1)
                                            {
                                                if ($currentpath->hover_fillcolor != "")
                                                {
                                                        if ($currentpath->hover_color != "")
                                                        {
                                                                $returnText .= '    ,';
                                                        }                    
                                                        else
                                                        {
                                                                $returnText .= '     ';
                                                        }                                    
                                                        $returnText .= 'fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                                }                                                              
                                            }
                                            $returnText .= '      });' ."\n";
                                    }
                                }
                                $returnText .= '    kmlLayer'. $currentpath->id.'.closeTooltip();' ."\n";

                                $returnText .= '  });' ."\n";
                        }

                    }

                }
                else
                {
                        if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                        {
                            if (isset($map->useajax) && (int)$map->useajax != 0)
                            {
                                    $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(kmlLayer'. $currentpath->id.');'."\n";
                            }
                            else
                            {
                                $returnText .= '  kmlLayer'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                                if (isset($currentpath->override_styles) && (int)$currentpath->override_styles == 0)
                                {
                                    // do not apply any style
                                }
                                else
                                {
                                    $returnText .= '    kmlLayer'. $currentpath->id.'.setStyle({' ."\n";    
                                    if ($currentpath->hover_color != "")
                                    {
                                            $returnText .= '     color: "'.$currentpath->hover_color.'"'."\n";
                                    }            
                                    if ((int)$currentpath->objecttype != 1)
                                    {
                                        if ($currentpath->hover_fillcolor != "")
                                        {
                                                if ($currentpath->hover_color != "")
                                                {
                                                        $returnText .= '    ,';
                                                }                    
                                                else
                                                {
                                                        $returnText .= '     ';
                                                }
                                                $returnText .= 'fillColor: "'.$currentpath->hover_fillcolor.'"'."\n";
                                        }                                                                               
                                    }
                                    $returnText .= '      });' ."\n";
                                }
                                $returnText .= '  });' ."\n";

                                $returnText .= '  kmlLayer'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                                if (isset($currentpath->override_styles) && (int)$currentpath->override_styles == 0)
                                {
                                    // do not apply any style
                                }
                                else
                                {
                                    $returnText .= '    kmlLayer'. $currentpath->id.'.setStyle({' ."\n";    
                                    if ($currentpath->hover_color != "")
                                    {
                                            $returnText .= '     color: "'.$currentpath->color.'"'."\n";
                                    }                                
                                    if ($currentpath->hover_fillcolor != "")
                                    {
                                            if ($currentpath->hover_color != "")
                                            {
                                                    $returnText .= '    ,';
                                            }                    
                                            else
                                            {
                                                    $returnText .= '     ';
                                            }                                    
                                            $returnText .= 'fillColor: "'.$currentpath->fillcolor.'"'."\n";
                                    }
                                    $returnText .= '      });' ."\n";
                                }
                                $returnText .= '  });' ."\n";
                            }
                        }                                                    
                }
        }
        else
        {
                if ($currentpath->hover_color != "" || $currentpath->hover_fillcolor != "")
                {
                    if (isset($map->useajax) && (int)$map->useajax != 0)
                    {
                            $returnText .= '  ajaxpathshover'.$mapDivSuffix.'.push(kmlLayer'. $currentpath->id.');'."\n";
                    }
                    else
                    {
                        $returnText .= '  kmlLayer'. $currentpath->id.'.on(\'mouseover\', function(event) {' ."\n";
                        if (isset($currentpath->override_styles) && (int)$currentpath->override_styles == 0)
                        {
                            // do not apply any style
                        }
                        else
                        {
                            $returnText .= '    kmlLayer'. $currentpath->id.'.setStyle({' ."\n";    
                            if ($currentpath->hover_color != "")
                            {
                                    $returnText .= '     color: "'.$currentpath->hover_color.'"'."\n";
                            }                
                            if ((int)$currentpath->objecttype != 1)
                            {
                                if ($currentpath->hover_fillcolor != "")
                                {
                                        if ($currentpath->hover_color != "")
                                        {
                                                $returnText .= '    ,';
                                        }                    
                                        else
                                        {
                                                $returnText .= '     ';
                                        }
                                        $returnText .= 'fillColor: "'.$currentpath->hover_fillcolor.'"'."\n";
                                }
                            }
                            $returnText .= '      });' ."\n";
                        }
                        
                        $returnText .= '  });' ."\n";
                        $returnText .= '  kmlLayer'. $currentpath->id.'.on(\'mouseout\', function(event) {' ."\n";
                        if (isset($currentpath->override_styles) && (int)$currentpath->override_styles == 0)
                        {
                            // do not apply any style
                        }
                        else
                        {                          
                            $returnText .= '    kmlLayer'. $currentpath->id.'.setStyle({' ."\n";    
                            if ($currentpath->hover_color != "")
                            {
                                    $returnText .= '     color: "'.$currentpath->color.'"'."\n";
                            }                                
                            if ($currentpath->hover_fillcolor != "")
                            {
                                    if ($currentpath->hover_color != "")
                                    {
                                            $returnText .= '    ,';
                                    }                    
                                    else
                                    {
                                            $returnText .= '     ';
                                    }                                    
                                    $returnText .= 'fillColor: "'.$currentpath->fillcolor.'"'."\n";
                            }
                            $returnText .= '      });' ."\n";
                        }
                        
                        $returnText .= '  });' ."\n";
                    }
                }                            
        }                                                                
        // Mouse hover - end

        if (isset($map->useajax) && (int)$map->useajax != 0)
        {
                // do not create listeners, create by loop only in the end
                $returnText .= '  ajaxpaths'.$mapDivSuffix.'.push(kmlLayer'. $currentpath->id.');'."\n";
        }
        else
        {
            // Action By Click Path - Begin                            
            switch ((int)$currentpath->actionbyclick)
            {
                    // None
                    case 0:
                    break;
                    // Info
                    case 1:
                        if ($managePanelInfowin == 1)
                        {
                            // do not bind popup for panel
                        }
                        else
                        {
                            if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
                            {
                                $returnText .= '  kmlLayer'.$currentpath->id.'.bindPopup(L.popup('.$scripttext_pp_main_style.').setContent(kmlLayer'. $currentpath->id.'.zhomInfowinContent));'."\n";
                            }
                            else
                            {
                                $returnText .= '  kmlLayer'. $currentpath->id.'.bindPopup(kmlLayer'. $currentpath->id.'.zhomInfowinContent);'."\n";
                            }
                        }

                        $returnText .= '  kmlLayer'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";

                        if ((int)$map->markerlistpos != 0)
                        {
                                $returnText .= '  Map_Animate_Marker_Hide_Force(map'.$mapDivSuffix.');'."\n";
                        }

                        if ($managePanelInfowin == 1)
                        {
                            $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.panelShowPathContent(this.zhomInfowinContent);' ."\n";
                        }    
                        else
                        {                                            
                            $returnText .= ' this.openPopup();' ."\n";
                        }


                        $returnText .= '  });' ."\n";
                    break;
                    // Link
                    case 2:
                            if ($currentpath->hrefsite != "")
                            {
                                    $returnText .= '  kmlLayer'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                    $returnText .= '  window.open("'.$currentpath->hrefsite.'");' ."\n";
                                    $returnText .= '  });' ."\n";                                            
                            }
                    break;
                    // Link in self
                    case 3:
                            if ($currentpath->hrefsite != "")
                            {
                                    $returnText .= '  kmlLayer'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                    $returnText .= '  window.location = "'.$currentpath->hrefsite.'";' ."\n";
                                    $returnText .= '  });' ."\n";
                            }
                    break;
                    default:
                            $returnText .= '' ."\n";
                    break;
            }
            // Action By Click Path - End

        }

        if (((isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0)
                || (isset($map->markermanager) && (int)$map->markermanager == 1))
          &&(isset($map->markergroupctlpath) 
          && (((int)$map->markergroupctlpath == 1) || ((int)$map->markergroupctlpath == 3))))
        {
                if ($zhomObjectManager != 0)
                {
                        $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.PathAdd('.$currentpath->markergroup.', kmlLayer'. $currentpath->id.');'."\n";
                }
        }
        else
        {
                $returnText .= 'kmlLayer'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');' ."\n";
        }

    }

}
elseif ((int)$currentpath->kmllayertype == 10
      ||(int)$currentpath->kmllayertype == 11)
{ 
    if (isset($currentpath->kmllayertype) && $currentpath->kmllayer != "") 
    {
        $returnText .= 'pathOpt'.$currentpath->id.' = new Object();'."\n";

        if (isset($currentpath->suppressinfowindows))
        {
            $returnText .= 'pathOpt'.$currentpath->id.'["suppressPopup"] = '.(int)$currentpath->suppressinfowindows.';'."\n";
        }
        if (isset($currentpath->popup_placemark))
        {
            $returnText .= 'pathOpt'.$currentpath->id.'["popupPlacemark"] = '.(int)$currentpath->popup_placemark.';'."\n";
        }
        if (isset($currentpath->popup_polyline))
        {
            $returnText .= 'pathOpt'.$currentpath->id.'["popupPolyline"] = '.(int)$currentpath->popup_polyline.';'."\n";
        }
        if (isset($currentpath->popup_polygon))
        {
            $returnText .= 'pathOpt'.$currentpath->id.'["popupPolygon"] = '.(int)$currentpath->popup_polygon.';'."\n";
        }
        if (isset($currentpath->tooltip_placemark))
        {
            $returnText .= 'pathOpt'.$currentpath->id.'["tooltipPlacemark"] = '.(int)$currentpath->tooltip_placemark.';'."\n";
        }
        if (isset($currentpath->tooltip_polyline))
        {
            $returnText .= 'pathOpt'.$currentpath->id.'["tooltipPolyline"] = '.(int)$currentpath->tooltip_polyline.';'."\n";
        }
        if (isset($currentpath->tooltip_polygon))
        {
            $returnText .= 'pathOpt'.$currentpath->id.'["tooltipPolygon"] = '.(int)$currentpath->tooltip_polygon.';'."\n";
        }

        if (isset($currentpath->showtype) && (int)$currentpath->showtype == 0)
        {
             $returnText .= 'pathOpt'.$currentpath->id.'["fitMapBounds"] = 1;' ."\n";
        }

        if ((isset($map->markercluster) && (int)$map->markercluster != 0))
        {
             $returnText .= 'pathOpt'.$currentpath->id.'["placemarkClusterer"] = 1;' ."\n";
        }


        if ((isset($map->markergroupctlmarker) && (int)$map->markergroupctlmarker != 0))
        {                              
            $returnText .= 'pathOpt'.$currentpath->id.'["controlByGroupListGroup"] = '.$currentpath->markergroup.';' ."\n";
        }
        else
        {                                    
            // 22.08.2014 placemarks in clusters, therefore not only 0-cluster
            if ((isset($map->markercluster) && (int)$map->markercluster == 1))
            {
                    if ((isset($map->markerclustergroup) && (int)$map->markerclustergroup == 1))
                    {
                        $returnText .= 'pathOpt'.$currentpath->id.'["controlByGroupListGroup"] = '.$currentpath->markergroup.';' ."\n";
                    }
                    else
                    {
                        $returnText .= 'pathOpt'.$currentpath->id.'["controlByGroupListGroup"] = 0;' ."\n";
                    }
            }
            else
            {
                    if ((isset($map->markerclustergroup) && (int)$map->markerclustergroup == 1))
                    {
                        $returnText .= 'pathOpt'.$currentpath->id.'["controlByGroupListGroup"] = '.$currentpath->markergroup.';' ."\n";
                    }
            }
        }


        // override icon by group
        if (isset($currentpath->override_placemarks) && (int)$currentpath->override_placemarks != 0)
        {
            if (isset($currentpath->overridemarkericon))
            {
                $returnText .= 'pathOpt'.$currentpath->id.'["overrideMarkerIcon"] = '.(int)$currentpath->overridemarkericon.';'."\n";
            }
            if (isset($currentpath->groupiconofsetx))
            {
                $returnText .= 'pathOpt'.$currentpath->id.'["groupIconOfsetX"] = '.(int)$currentpath->groupiconofsetx.';'."\n";
            }
            if (isset($currentpath->groupiconofsety))
            {
                $returnText .= 'pathOpt'.$currentpath->id.'["groupIconOfsetY"] = '.(int)$currentpath->groupiconofsety.';'."\n";
            }
            if (isset($currentpath->groupicontype))
            {
                $returnText .= 'pathOpt'.$currentpath->id.'["groupIconType"] = "'.$imgpathIcons.str_replace("#", "%23", $currentpath->groupicontype).'.png'.'";' ."\n";
            }
        }

        if (isset($currentpath->override_styles) && (int)$currentpath->override_styles != 0)
        {
            $returnText .= 'pathOpt'.$currentpath->id.'["overrideStyles"] = '.(int)$currentpath->override_styles.';'."\n";
            
            $returnText .= 'pathOpt'.$currentpath->id.'["overrideStyles_line_color"] = "'.$currentpath->color.'";'."\n";
            $returnText .= 'pathOpt'.$currentpath->id.'["overrideStyles_line_width"] = "'.$currentpath->weight.'";'."\n";
            $returnText .= 'pathOpt'.$currentpath->id.'["overrideStyles_line_opacity"] = "'.$currentpath->opacity.'";'."\n";
        
            $returnText .= 'pathOpt'.$currentpath->id.'["overrideStyles_hover_line_color"] = "'.$currentpath->hover_color.'";'."\n";

            $returnText .= 'pathOpt'.$currentpath->id.'["overrideStyles_fill_color"] = "'.$currentpath->fillcolor.'";'."\n";
            $returnText .= 'pathOpt'.$currentpath->id.'["overrideStyles_fill_opacity"] = "'.$currentpath->fillopacity.'";'."\n";
            $returnText .= 'pathOpt'.$currentpath->id.'["overrideStyles_hover_fill_color"] = "'.$currentpath->hover_fillcolor.'";'."\n";
            
        }
        //$returnText .= 'alert(JSON.stringify(pathOpt'.$currentpath->id.'));'."\n";

        $returnText .= 'pathOpt'.$currentpath->id.' = JSON.parse(JSON.stringify(pathOpt'.$currentpath->id.'));'."\n";

        if ((int)$currentpath->kmllayertype == 10)
        {
            if (isset($currentpath->elevation) && (int)$currentpath->elevation != 0)
            {
                $returnText .= 'pathOpt'.$currentpath->id.'["elevationPosition"] = '.(int)$currentpath->elevation.';'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_theme"] = '.(int)$currentpath->elevation_theme.';'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_width"] = "'.$currentpath->elevation_width.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_height"] = "'.$currentpath->elevation_height.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_summary"] = '.(int)$currentpath->elevation_summary.';'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["y_min_value"] = "'.$currentpath->y_min_value.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["y_max_value"] = "'.$currentpath->y_max_value.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["x_gridline_count"] = "'.$currentpath->x_gridline_count.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["y_gridline_count"] = "'.$currentpath->y_gridline_count.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_follow"] = '.(int)$currentpath->elevation_follow.';'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_unitsystem"] = '.(int)$currentpath->elevation_unitsystem.';'."\n";
				$returnText .= 'pathOpt'.$currentpath->id.'["elevation_showtime"] = '.(int)$currentpath->show_time.';'."\n";
				
				$returnText .= 'pathOpt'.$currentpath->id.'["elevation_div"] = "#OMapsElevation'.$mapDivSuffix.'";'."\n";
				
            
                //$wa->registerAndUseScript('zhosmmaps.d3',$current_custom_js_path.'d3/5.15.0/d3.min.js');
                //$wa->registerAndUseStyle('zhosmmaps.leaflet-elevation',$current_custom_js_path.'leaflet-elevation/0.6.8/leaflet-elevation.min.css');  
				$wa->registerAndUseStyle('zhosmmaps.leaflet-elevation', 'https://unpkg.com/@raruto/leaflet-elevation@2.2.8/dist/leaflet-elevation.min.css');				
				//$wa->registerAndUseScript('zhosmmaps.leaflet-elevation',$current_custom_js_path.'leaflet-elevation/0.6.8/leaflet-elevation.min.js');
				$wa->registerAndUseScript('zhosmmaps.leaflet-elevation','https://unpkg.com/@raruto/leaflet-elevation@2.2.8/dist/leaflet-elevation.min.js');
                // add custom styles
                //$wa->registerAndUseStyle('zhosmmaps.leaflet-elevation-custom',$current_custom_js_path.'leaflet-elevation/0.6.8/leaflet-elevation-custom.css');
				
            }
            
            $returnText .= 'var kmlLayer'.$currentpath->id.' = zhomPathParser'.$mapDivSuffix.'.kml(\''.$currentpath->kmllayer.'\', pathOpt'.$currentpath->id.');' ."\n";
        }
        else if ((int)$currentpath->kmllayertype == 11)
        {
            if (isset($currentpath->elevation) && (int)$currentpath->elevation != 0)
            {
                $returnText .= 'pathOpt'.$currentpath->id.'["elevationPosition"] = '.(int)$currentpath->elevation.';'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_theme"] = '.(int)$currentpath->elevation_theme.';'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_width"] = "'.$currentpath->elevation_width.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_height"] = "'.$currentpath->elevation_height.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_summary"] = '.(int)$currentpath->elevation_summary.';'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["y_min_value"] = "'.$currentpath->y_min_value.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["y_max_value"] = "'.$currentpath->y_max_value.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["x_gridline_count"] = "'.$currentpath->x_gridline_count.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["y_gridline_count"] = "'.$currentpath->y_gridline_count.'";'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_follow"] = '.(int)$currentpath->elevation_follow.';'."\n";
                $returnText .= 'pathOpt'.$currentpath->id.'["elevation_unitsystem"] = '.(int)$currentpath->elevation_unitsystem.';'."\n";
				$returnText .= 'pathOpt'.$currentpath->id.'["elevation_showtime"] = '.(int)$currentpath->show_time.';'."\n";
				
				$returnText .= 'pathOpt'.$currentpath->id.'["elevation_div"] = "#OMapsElevation'.$mapDivSuffix.'";'."\n";
            
                //$wa->registerAndUseScript('zhosmmaps.d3',$current_custom_js_path.'d3/5.15.0/d3.min.js');
                //$wa->registerAndUseStyle('zhosmmaps.leaflet-elevation',$current_custom_js_path.'leaflet-elevation/0.6.8/leaflet-elevation.min.css');    
				$wa->registerAndUseStyle('zhosmmaps.leaflet-elevation', 'https://unpkg.com/@raruto/leaflet-elevation@2.2.8/dist/leaflet-elevation.min.css');				
                //$wa->registerAndUseScript('zhosmmaps.leaflet-elevation',$current_custom_js_path.'leaflet-elevation/0.6.8/leaflet-elevation.min.js');
				$wa->registerAndUseScript('zhosmmaps.leaflet-elevation','https://unpkg.com/@raruto/leaflet-elevation@2.2.8/dist/leaflet-elevation.min.js');
                
                // add custom styles
                //$wa->registerAndUseStyle('zhosmmaps.leaflet-elevation-custom',$current_custom_js_path.'leaflet-elevation/0.6.8/leaflet-elevation-custom.css');
            }
                   
            $returnText .= 'var kmlLayer'.$currentpath->id.' = zhomPathParser'.$mapDivSuffix.'.gpx(\''.$currentpath->kmllayer.'\', pathOpt'.$currentpath->id.');' ."\n";
        }

        $returnText .= '  kmlLayer'. $currentpath->id.'.zhomPathID = '. $currentpath->id.';' ."\n";
        $returnText .= '  kmlLayer'. $currentpath->id.'.zhomObjectType = '. $currentpath->objecttype.';' ."\n";
        $returnText .= '  kmlLayer'. $currentpath->id.'.zhomInfowinContent = contentPathString'. $currentpath->id.';' ."\n";    
        $returnText .= '  kmlLayer'. $currentpath->id.'.zhomTitle = "'.str_replace('\\', '/', str_replace('"', '\'\'', $currentpath->title)).'";' ."\n";    


        if (((isset($map->markergroupcontrol) && (int)$map->markergroupcontrol != 0)
         || (isset($map->markermanager) && (int)$map->markermanager == 1))
          &&(isset($map->markergroupctlpath) 
          && (((int)$map->markergroupctlpath == 1) || ((int)$map->markergroupctlpath == 3))))
        {
            if ($zhomObjectManager != 0)
            {
                    $returnText .= '  zhomObjMgr'.$mapDivSuffix.'.PathAdd('.$currentpath->markergroup.', kmlLayer'. $currentpath->id.');'."\n";
            }
        }
        else
        {
                $returnText .= 'kmlLayer'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');' ."\n";
        }
    }
}   



if ($currentpath->imgurl != ""
    && $currentpath->imgbounds != "") 
{


    $imgGroundBoundsArray = explode(";", str_replace(',',';',$currentpath->imgbounds));
    if (count($imgGroundBoundsArray) != 4)
    {
        $returnText .= 'alert("'.Text::_('COM_ZHOSMMAP_MAP_ERROR_IMGGROUNDBOUNDS').'");'."\n";
    }
    else
    {
        $returnText .= 'var imgGroundBounds'. $currentpath->id.' = [' ."\n";
        $returnText .= '      ['.$imgGroundBoundsArray[0].', '.$imgGroundBoundsArray[1].'],' ."\n";
        $returnText .= '      ['.$imgGroundBoundsArray[2].', '.$imgGroundBoundsArray[3].']];' ."\n";


        $returnText .= 'var imgGroundOptions'. $currentpath->id.' = {' ."\n";
        if (isset($currentpath->imgopacity))
        {
            if ($currentpath->imgopacity != "")
            {
                $returnText .= '  opacity:'.$currentpath->imgopacity ."\n";
            }
            else
            {
                $returnText .= '  opacity: 1'."\n";
            }    
        }
        else
        {
            $returnText .= '  opacity: 1'."\n";
        }

        if (isset($currentpath->imgclickable))
        {
                if ((int)$currentpath->imgclickable == 1)
                {
                        $returnText .= ', interactive:true' ."\n";
                }
                else
                {
                        $returnText .= ', interactive:false' ."\n";
                }
        }
        $returnText .= '};' ."\n";

        $returnText .= 'var imgGroundLayer'. $currentpath->id.' = L.imageOverlay(\''.$currentpath->imgurl.'\', imgGroundBounds'. $currentpath->id.', imgGroundOptions'. $currentpath->id.');' ."\n";

        $returnText .= '  imgGroundLayer'. $currentpath->id.'.zhomPathID = '. $currentpath->id.';' ."\n";
        $returnText .= '  imgGroundLayer'. $currentpath->id.'.zhomInfowinContent = contentPathString'. $currentpath->id.';' ."\n";    
        $returnText .= '  imgGroundLayer'. $currentpath->id.'.zhomTitle = "'.str_replace('\\', '/', str_replace('"', '\'\'', $currentpath->title)).'";' ."\n";    


        $returnText .= 'imgGroundLayer'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');' ."\n";

        if ($needOverlayControl != 0)
        {
            if ((int)$currentpath->imgopacitymanage == 1)
            {
                $returnText .= 'zhomObjMgr'.$mapDivSuffix.'.addGroundOverlay(imgGroundLayer'.$currentpath->id.');'."\n";
            }
        }


        if (isset($currentpath->imgclickable))
        {
            if (isset($map->useajax) && (int)$map->useajax != 0)
            {
                    // do not create listeners, create by loop only in the end
                    $returnText .= '  ajaxpathsOVL'.$mapDivSuffix.'.push(imgGroundLayer'. $currentpath->id.');'."\n";
            }
            else
            {
                if ((int)$currentpath->imgclickable == 1)
                {                    
                        // Action By Click Path - Begin                            
                        switch ((int)$currentpath->actionbyclick)
                        {
                                // None
                                case 0:
                                break;
                                // Info
                                case 1:
                                        if (isset($map->disableautopan) && ((int)$map->disableautopan == 1))    
                                        {
                                            $returnText .= '  imgGroundLayer'.$currentpath->id.'.bindPopup(L.popup('.$scripttext_pp_main_style.').setContent(imgGroundLayer'. $currentpath->id.'.zhomInfowinContent));'."\n";
                                        }
                                        else
                                        {
                                            $returnText .= '  imgGroundLayer'. $currentpath->id.'.bindPopup(imgGroundLayer'. $currentpath->id.'.zhomInfowinContent);'."\n";
                                        }

                                        $returnText .= '  imgGroundLayer'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";

                                        $returnText .= '  this.openPopup(event.latlng);' ."\n";
                                        $returnText .= '  });' ."\n";
                                break;
                                // Link
                                case 2:
                                        if ($currentpath->hrefsite != "")
                                        {
                                                $returnText .= '  imgGroundLayer'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                                $returnText .= '  window.open("'.$currentpath->hrefsite.'");' ."\n";
                                                $returnText .= '  });' ."\n";                                            
                                        }
                                break;
                                // Link in self
                                case 3:
                                        if ($currentpath->hrefsite != "")
                                        {
                                                $returnText .= '  imgGroundLayer'. $currentpath->id.'.on(\'click\', function(event) {' ."\n";
                                                $returnText .= '  window.location = "'.$currentpath->hrefsite.'";' ."\n";
                                                $returnText .= '  });' ."\n";
                                        }
                                break;
                                default:
                                        $returnText .= '' ."\n";
                                break;
                        }
                        // Action By Click Path - End    
                }

            }
        }
    }



}

if ($currentpath->gridtilefunc != "")
{

    $returnText .= 'var gridLayerOptions'. $currentpath->id.' = {' ."\n";
    if (isset($currentpath->gridopacity))
    {
        if ($currentpath->gridopacity != "")
        {
            $returnText .= '  opacity:'.$currentpath->gridopacity ."\n";
        }
        else
        {
            $returnText .= '  opacity: 1'."\n";
        }    
    }
    else
    {
        $returnText .= '  opacity: 1'."\n";
    }

    $returnText .= '};' ."\n";

    $returnText .= 'var gridLayer'. $currentpath->id.' = new L.GridLayer(gridLayerOptions'. $currentpath->id.');' ."\n";

    $returnText .= 'gridLayer'. $currentpath->id.'.createTile = '.$currentpath->gridtilefunc ."\n";

    $returnText .= 'gridLayer'. $currentpath->id.'.addTo(map'.$mapDivSuffix.');' ."\n";

}
