<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap Component
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Site\Helper;
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Component\ComponentHelper;

abstract class MapDataHelper
{

    public static function getMap($id) 
    {
            $db = Factory::getDBO();

            $query = $db->getQuery(true);

            $query->select('h.*, c.title as category')
                    ->from('#__zhosmmaps_maps as h')
                    ->leftJoin('#__categories as c ON h.catid=c.id')
                    ->where('h.id=' . (int)$id);

            $db->setQuery($query);        
                
            $item = $db->loadObject();

            return $item;
    }

    public static function getMarkers($id, 
                                      $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
                                      $usermarkers, $usermarkersfilter, $usercontact, $markerorder) 
    {        
            $db = Factory::getDBO();

            $query = $db->getQuery(true);

            $addWhereClause = '';

            if ($placemarklistid == ""
             && $grouplistid == ""
             && $categorylistid == ""
             && $taglistid == ""
            )
            {

                    $addWhereClause .= ' and h.mapid='.(int)$id;

                    if ($explacemarklistid != "")
                    {
                            $tmp_expl_ids = explode(',', str_replace(';',',', $explacemarklistid));                                       
                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                            if (strpos($tmp_expl_ids, ','))
                            {
                                    $addWhereClause .= ' and h.id NOT IN ('.$tmp_expl_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.id != '.(int)$tmp_expl_ids;
                            }
                    }
            }
            else
            {
                    if ($placemarklistid != "")
                    {
                            $tmp_pl_ids = explode(',', str_replace(';',',', $placemarklistid));                                       
                            $tmp_pl_ids = ArrayHelper::toInteger($tmp_pl_ids);
                            $tmp_pl_ids = implode(',', $tmp_pl_ids);

                            if (strpos($tmp_pl_ids, ','))
                            {
                                    $addWhereClause .= ' and h.id IN ('.$tmp_pl_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.id = '.(int)$tmp_pl_ids;
                            }
                    }
                    if ($explacemarklistid != "")
                    {
                            $tmp_expl_ids = explode(',', str_replace(';',',', $explacemarklistid));                                       
                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                            if (strpos($tmp_expl_ids, ','))
                            {
                                    $addWhereClause .= ' and h.id NOT IN ('.$tmp_expl_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.id != '.(int)$tmp_expl_ids;
                            }
                    }
                    if ($grouplistid != "")
                    {
                            $tmp_grp_ids = explode(',', str_replace(';',',', $grouplistid));                                       
                            $tmp_grp_ids = ArrayHelper::toInteger($tmp_grp_ids);
                            $tmp_grp_ids = implode(',', $tmp_grp_ids);

                            if (strpos($tmp_grp_ids, ','))
                            {
                                    $addWhereClause .= ' and h.markergroup IN ('.$tmp_grp_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.markergroup = '.(int)$tmp_grp_ids;
                            }
                    }
                    if ($categorylistid != "")
                    {
                            $tmp_cat_ids = explode(',', str_replace(';',',', $categorylistid));                                       
                            $tmp_cat_ids = ArrayHelper::toInteger($tmp_cat_ids);
                            $tmp_cat_ids = implode(',', $tmp_cat_ids);

                            if (strpos($tmp_cat_ids, ','))
                            {
                                    $addWhereClause .= ' and h.catid IN ('.$tmp_cat_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.catid = '.(int)$tmp_cat_ids;
                            }
                    }
                    // tag search is not as usual
                    if ($taglistid != "")
                    {
                            $tmp_tag_ids = explode(',', str_replace(';',',', $taglistid));                                       
                            $tmp_tag_ids = ArrayHelper::toInteger($tmp_tag_ids);
                            $tmp_tag_ids = implode(',', $tmp_tag_ids);                         
                            if (strpos($tmp_tag_ids, ','))
                            {
                                $addWherePlacemarkTag = ' and tagmap.tag_id IN ('.$tmp_tag_ids.')';                         
                            }
                            else
                            {
                                $addWherePlacemarkTag = ' and tagmap.tag_id = '. (int) $tmp_tag_ids;                                              
                            }

                            $addWherePlacemarkTagExist = ' AND EXISTS (SELECT 1 FROM #__contentitem_tag_map AS tagmap '.
                                                         ' WHERE tagmap.content_item_id = h.id '.
                                                         ' AND tagmap.type_alias = \'com_zhosmmap.mapmarker\''.$addWherePlacemarkTag.')';    

                            $addWhereClause .= $addWherePlacemarkTagExist;        
                    }
            }


            // Create some addition filters - Begin

            if ($usermarkers == 0)
            {
                    // You can not enter markers

                    // You can see all published, and you can't enter markers

                    switch ((int)$usermarkersfilter)
                    {
                            case 0:
                                    $addWhereClause .= ' and h.published=1';
                            break;
                            case 1:
                                    $currentUser = Factory::getUser();
                                    $addWhereClause .= ' and h.published=1';
                                    $addWhereClause .= ' and h.createdbyuser='.(int)$currentUser->id;
                            break;
                            case 2:
                                    $currentUser = Factory::getUser();
                                    $currentUserGroups = implode(',', $currentUser->getAuthorisedViewLevels());
                                    $addWhereClause .= ' and h.published=1';
                                    $addWhereClause .= ' and h.access IN (' . $currentUserGroups . ')';
                            break;
                            default:
                                    $addWhereClause .= ' and h.published=1';
                            break;                    
                    }
            }
            else
            {
                    // You can enter markers

                    switch ((int)$usermarkersfilter)
                    {
                            case 0:
                                    $currentUser = Factory::getUser();
                                    if ((int)$currentUser->id == 0)
                                    {
                                            $addWhereClause .= ' and h.published=1';
                                    }
                                    else
                                    {
                                            $addWhereClause .= ' and (h.published=1 or h.createdbyuser='.(int)$currentUser->id .')';
                                    }
                            break;
                            case 1:
                                    $currentUser = Factory::getUser();
                                    if ((int)$currentUser->id == 0)
                                    {
                                            $addWhereClause .= ' and h.published=1';
                                            $addWhereClause .= ' and h.createdbyuser='.(int)$currentUser->id;
                                    }
                                    else
                                    {
                                            $addWhereClause .= ' and h.createdbyuser='.(int)$currentUser->id;
                                    }
                            break;
                            case 2:
                                    $currentUser = Factory::getUser();
                                    $currentUserGroups = implode(',', $currentUser->getAuthorisedViewLevels());
                                    $addWhereClause .= ' and h.published=1';
                                    $addWhereClause .= ' and h.access IN (' . $currentUserGroups . ')';
                            break;
                            default:
                                    $addWhereClause .= ' and h.published=1';
                            break;                    
                    }
            }
            // Create some addition filters - End


            if ((int)$usercontact == 1)
            {
                    $query->select('h.*, '.
                            ' c.title as category, g.icontype as groupicontype, g.overridemarkericon as overridemarkericon, g.published as publishedgroup, g.markermanagerminzoom as markermanagerminzoom, g.markermanagermaxzoom as markermanagermaxzoom, g.activeincluster as activeincluster, '.
                            ' g.iconofsetx as groupiconofsetx, g.iconofsety as groupiconofsety,'.
                            ' cn.name as contact_name, cn.address as contact_address, cn.con_position as contact_position, cn.telephone as contact_phone, cn.mobile as contact_mobile, cn.fax as contact_fax, cn.email_to as contact_email, cn.webpage as contact_webpage, '.
                            ' cn.suburb as contact_suburb, cn.state as contact_state, cn.country as contact_country, cn.postcode as contact_postcode,'.
                            ' bub.minwidth, bub.maxwidth, bub.minheight, bub.maxheight, bub.disableautopan, bub.published infobubblepublished, bub.offsetx, bub.offsety')
                            ->from('#__zhosmmaps_markers as h')
                            ->leftJoin('#__categories as c ON h.catid=c.id')
                            ->leftJoin('#__zhosmmaps_markergroups as g ON h.markergroup=g.id')
                            ->leftJoin('#__zhosmmaps_infobubbles as bub ON h.tabid=bub.id')
                            ->leftJoin('#__contact_details as cn ON h.contactid=cn.id')
                            ->where('1=1' . $addWhereClause);
            }
            else
            {
                    $query->select('h.*, '.
                            ' c.title as category, g.icontype as groupicontype, g.overridemarkericon as overridemarkericon, g.published as publishedgroup, g.markermanagerminzoom as markermanagerminzoom, g.markermanagermaxzoom as markermanagermaxzoom, g.activeincluster as activeincluster, '.
                            ' g.iconofsetx as groupiconofsetx, g.iconofsety as groupiconofsety,'.
                            ' bub.minwidth, bub.maxwidth, bub.minheight, bub.maxheight, bub.disableautopan, bub.published infobubblepublished, bub.offsetx, bub.offsety')                
                            ->from('#__zhosmmaps_markers as h')
                            ->leftJoin('#__categories as c ON h.catid=c.id')
                            ->leftJoin('#__zhosmmaps_markergroups as g ON h.markergroup=g.id')
                            ->leftJoin('#__zhosmmaps_infobubbles as bub ON h.tabid=bub.id')
                            ->where('1=1' . $addWhereClause);

            }


            if ((int)$markerorder == 0)
            {
                    $query->order('h.title');
            }
            else if ((int)$markerorder == 1)
            {
                    $query->order('c.title, h.ordering');
            }
            else if ((int)$markerorder == 2)
            {
                    $query->order('c.title desc, h.ordering');
            }
            else if ((int)$markerorder == 10)
            {
                    $query->order('h.userorder, h.title');
            }
            else if ((int)$markerorder == 20)
            {
                    $query->order('g.title, h.title');
            }
            else if ((int)$markerorder == 21)
            {
                    $query->order('g.title desc, h.title');
            }
            else if ((int)$markerorder == 22)
            {
                    $query->order('g.userorder, g.title, h.title');
            }
            else if ((int)$markerorder == 23)
            {
                    $query->order('g.userorder desc, g.title, h.title');
            }
            else if ((int)$markerorder == 30)
            {
                    $query->order('h.createddate, h.title');
            }
            else if ((int)$markerorder == 31)
            {
                    $query->order('h.createddate desc, h.title');
            }
            else 
            {
                    $query->order('h.title');
            }                    

            $nowDate = $db->Quote(Factory::getDate()->toSQL());
            $query->where('(h.publish_up IS NULL OR h.publish_up <= ' . $nowDate . ')');
            $query->where('(h.publish_down IS NULL OR h.publish_down >= ' . $nowDate . ')');

            $db->setQuery($query);        
            
            // Markers
            $markers = $db->loadObjectList();


            return $markers;

    }
    
    public static function getRouters($id, $routelistid, $exroutelistid, $grouplistid, $categorylistid) 
    {
            $db = Factory::getDBO();

            $query = $db->getQuery(true);

            $addWhereClause = '';

            if ($routelistid == ""
                    && $grouplistid == ""
                    && $categorylistid == ""
                    )
            {

                    $addWhereClause .= ' and h.mapid='.(int)$id;

                    if ($exroutelistid != "")
                    {
                            $tmp_expl_ids = explode(',', str_replace(';',',', $exroutelistid));                                       
                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                            if (strpos($tmp_expl_ids, ','))
                            {
                                    $addWhereClause .= ' and h.id NOT IN ('.$tmp_expl_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.id != '.(int)$tmp_expl_ids;
                            }
                    }
            }
            else
            {
                    if ($routelistid != "")
                    {
                            $tmp_pl_ids = explode(',', str_replace(';',',', $routelistid));                                       
                            $tmp_pl_ids = ArrayHelper::toInteger($tmp_pl_ids);
                            $tmp_pl_ids = implode(',', $tmp_pl_ids);

                            if (strpos($tmp_pl_ids, ','))
                            {
                                    $addWhereClause .= ' and h.id IN ('.$tmp_pl_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.id = '.(int)$tmp_pl_ids;
                            }
                    }
                    if ($exroutelistid != "")
                    {
                            $tmp_expl_ids = explode(',', str_replace(';',',', $exroutelistid));                                       
                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                            if (strpos($tmp_expl_ids, ','))
                            {
                                    $addWhereClause .= ' and h.id NOT IN ('.$tmp_expl_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.id != '.(int)$tmp_expl_ids;
                            }
                    }
                    if ($grouplistid != "")
                    {
                            $tmp_grp_ids = explode(',', str_replace(';',',', $grouplistid));                                       
                            $tmp_grp_ids = ArrayHelper::toInteger($tmp_grp_ids);
                            $tmp_grp_ids = implode(',', $tmp_grp_ids);
                            /* it is not in table yet
                            if (strpos($tmp_grp_ids, ','))
                            {
                                    $addWhereClause .= ' and h.markergroup IN ('.$tmp_grp_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.markergroup = '.(int)$tmp_grp_ids;
                            }
                            */
                    }
                    if ($categorylistid != "")
                    {
                            $tmp_cat_ids = explode(',', str_replace(';',',', $categorylistid));                                       
                            $tmp_cat_ids = ArrayHelper::toInteger($tmp_cat_ids);
                            $tmp_cat_ids = implode(',', $tmp_cat_ids);

                            if (strpos($tmp_cat_ids, ','))
                            {
                                    $addWhereClause .= ' and h.catid IN ('.$tmp_cat_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.catid = '.(int)$tmp_cat_ids;
                            }
                    }
            }



            $query->select('h.*, c.title as category ')
                    ->from('#__zhosmmaps_routers as h')
                    ->leftJoin('#__categories as c ON h.catid=c.id')
                    ->where('h.published=1'.$addWhereClause);

            $db->setQuery($query);        

            // Routers
            $routers = $db->loadObjectList();

            return $routers;
    }

    public static function getMarkerGroups($id, 
                                           $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
                                           $markergrouporder) 
    {

                $db = Factory::getDBO();

                $query = $db->getQuery(true);
            
                $addWhereClause = "";

                if ($placemarklistid == ""
                 && $grouplistid == ""
                 && $categorylistid == ""
                 && $taglistid == ""
                )
                {
                        $addWhereClause .= ' and m.mapid='.(int)$id;
                        if ($explacemarklistid != "")
                        {
                                $tmp_expl_ids = explode(',', str_replace(';',',', $explacemarklistid));                                       
                                $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                                $tmp_expl_ids = implode(',', $tmp_expl_ids);

                                if (strpos($tmp_expl_ids, ','))
                                {
                                        $addWhereClause .= ' and m.id NOT IN ('.$tmp_expl_ids.')';
                                }
                                else
                                {
                                        $addWhereClause .= ' and m.id != '.(int)$tmp_expl_ids;
                                }
                        }
                }
                else
                {
                        if ($placemarklistid != "")
                        {
                                $tmp_pl_ids = explode(',', str_replace(';',',', $placemarklistid));                                       
                                $tmp_pl_ids = ArrayHelper::toInteger($tmp_pl_ids);
                                $tmp_pl_ids = implode(',', $tmp_pl_ids);

                                if (strpos($tmp_pl_ids, ','))
                                {
                                        $addWhereClause .= ' and m.id IN ('.$tmp_pl_ids.')';
                                }
                                else
                                {
                                        $addWhereClause .= ' and m.id = '.(int)$tmp_pl_ids;
                                }
                        }
                        if ($explacemarklistid != "")
                        {
                                $tmp_expl_ids = explode(',', str_replace(';',',', $explacemarklistid));                                       
                                $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                                $tmp_expl_ids = implode(',', $tmp_expl_ids);

                                if (strpos($tmp_expl_ids, ','))
                                {
                                        $addWhereClause .= ' and m.id NOT IN ('.$tmp_expl_ids.')';
                                }
                                else
                                {
                                        $addWhereClause .= ' and m.id != '.(int)$tmp_expl_ids;
                                }
                        }
                        if ($grouplistid != "")
                        {
                                $tmp_grp_ids = explode(',', str_replace(';',',', $grouplistid));                                       
                                $tmp_grp_ids = ArrayHelper::toInteger($tmp_grp_ids);
                                $tmp_grp_ids = implode(',', $tmp_grp_ids);

                                if (strpos($tmp_grp_ids, ','))
                                {
                                        $addWhereClause .= ' and m.markergroup IN ('.$tmp_grp_ids.')';
                                }
                                else
                                {
                                        $addWhereClause .= ' and m.markergroup = '.(int)$tmp_grp_ids;
                                }
                        }
                        if ($categorylistid != "")
                        {
                                $tmp_cat_ids = explode(',', str_replace(';',',', $categorylistid));                                       
                                $tmp_cat_ids = ArrayHelper::toInteger($tmp_cat_ids);
                                $tmp_cat_ids = implode(',', $tmp_cat_ids);

                                if (strpos($tmp_cat_ids, ','))
                                {
                                        $addWhereClause .= ' and m.catid IN ('.$tmp_cat_ids.')';
                                }
                                else
                                {
                                        $addWhereClause .= ' and m.catid = '.(int)$tmp_cat_ids;
                                }
                        }
                        // tag search is not as usual
                        if ($taglistid != "")
                        {
                                $tmp_tag_ids = explode(',', str_replace(';',',', $taglistid));                                       
                                $tmp_tag_ids = ArrayHelper::toInteger($tmp_tag_ids);
                                $tmp_tag_ids = implode(',', $tmp_tag_ids);                         
                                if (strpos($tmp_tag_ids, ','))
                                {
                                    $addWherePlacemarkTag = ' and tagmap.tag_id IN ('.$tmp_tag_ids.')';                         
                                }
                                else
                                {
                                    $addWherePlacemarkTag = ' and tagmap.tag_id = '. (int) $tmp_tag_ids;                                              
                                }

                                $addWherePlacemarkTagExist = ' AND EXISTS (SELECT 1 FROM #__contentitem_tag_map AS tagmap '.
                                                             ' WHERE tagmap.content_item_id = m.id '.
                                                             ' AND tagmap.type_alias = \'com_zhosmmap.mapmarker\''.$addWherePlacemarkTag.')';    

                                $addWhereClause .= $addWherePlacemarkTagExist;        
                        }
                }
                
                


                // Remove 'h.published=1 and m.published=1
                // because group may be disabled, but manual edit users placemark enable

                $nowDate = $db->Quote(Factory::getDate()->toSQL());
                $addWhereClause .= ' and (m.publish_up IS NULL OR m.publish_up <= ' . $nowDate . ')';
                $addWhereClause .= ' and (m.publish_down IS NULL OR m.publish_down >= ' . $nowDate . ')';
                
                $query->select('h.*, c.title as category ')
                        ->from('#__zhosmmaps_markergroups as h')
                        ->leftJoin('#__categories as c ON h.catid=c.id')
                        ->where(' EXISTS (SELECT 1 FROM #__zhosmmaps_markers as m WHERE m.markergroup=h.id ' . $addWhereClause . ')' )
                        ;

                if ((int)$markergrouporder == 0)
                {
                        $query->order('h.title');
                }
                else if ((int)$markergrouporder == 1)
                {
                        $query->order('c.title, h.ordering');
                }
                else if ((int)$markergrouporder == 2)
                {
                        $query->order('c.title, h.title');
                }
                else if ((int)$markergrouporder == 10)
                {
                        $query->order('h.userorder, h.title');
                }
                else 
                {
                        $query->order('h.title');
                }

                $db->setQuery($query);        

                // MarkerGroups
                $markergroups = $db->loadObjectList();


        return $markergroups;
    }

    public static function getMarkerGroupsManage($id, 
                                                 $placemarklistid, $explacemarklistid, $grouplistid, $categorylistid, $taglistid,
                                                 $markergrouporder, $markergroupshowicon,
                                                 $markergroupctlmarker, 
                                                 $markergroupctlpath,
                                                 $pathlistid, $expathlistid, $grouplistpathid, $categorylistpathid, $pathtaglistid) 
    {


            $db = Factory::getDBO();

            $query = $db->getQuery(true);

            $addWhereClause = "";
            $addWhereClausePath = "";

            if ((int)$markergroupctlmarker == 1)
            {

                    if ($placemarklistid == ""
                     && $grouplistid == ""
                     && $categorylistid == ""
                     && $taglistid == ""
                    )
                    {
                            $addWhereClause .= ' and m.mapid='.(int)$id;

                            if ($explacemarklistid != "")
                            {
                                    $tmp_expl_ids = explode(',', str_replace(';',',', $explacemarklistid));                                       
                                    $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                                    $tmp_expl_ids = implode(',', $tmp_expl_ids);

                                    if (strpos($tmp_expl_ids, ','))
                                    {
                                            $addWhereClause .= ' and m.id NOT IN ('.$tmp_expl_ids.')';
                                    }
                                    else
                                    {
                                            $addWhereClause .= ' and m.id != '.(int)$tmp_expl_ids;
                                    }
                            }

                    }
                    else
                    {
                            if ($placemarklistid != "")
                            {
                                    $tmp_pl_ids = explode(',', str_replace(';',',', $placemarklistid));                                       
                                    $tmp_pl_ids = ArrayHelper::toInteger($tmp_pl_ids);
                                    $tmp_pl_ids = implode(',', $tmp_pl_ids);

                                    if (strpos($tmp_pl_ids, ','))
                                    {
                                            $addWhereClause .= ' and m.id IN ('.$tmp_pl_ids.')';
                                    }
                                    else
                                    {
                                            $addWhereClause .= ' and m.id = '.(int)$tmp_pl_ids;
                                    }
                            }
                            if ($explacemarklistid != "")
                            {
                                    $tmp_expl_ids = explode(',', str_replace(';',',', $explacemarklistid));                                       
                                    $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                                    $tmp_expl_ids = implode(',', $tmp_expl_ids);

                                    if (strpos($tmp_expl_ids, ','))
                                    {
                                            $addWhereClause .= ' and m.id NOT IN ('.$tmp_expl_ids.')';
                                    }
                                    else
                                    {
                                            $addWhereClause .= ' and m.id != '.(int)$tmp_expl_ids;
                                    }
                            }
                            if ($grouplistid != "")
                            {
                                    $tmp_grp_ids = explode(',', str_replace(';',',', $grouplistid));                                       
                                    $tmp_grp_ids = ArrayHelper::toInteger($tmp_grp_ids);
                                    $tmp_grp_ids = implode(',', $tmp_grp_ids);

                                    if (strpos($tmp_grp_ids, ','))
                                    {
                                            $addWhereClause .= ' and m.markergroup IN ('.$tmp_grp_ids.')';
                                    }
                                    else
                                    {
                                            $addWhereClause .= ' and m.markergroup = '.(int)$tmp_grp_ids;
                                    }
                            }
                            if ($categorylistid != "")
                            {
                                    $tmp_cat_ids = explode(',', str_replace(';',',', $categorylistid));                                       
                                    $tmp_cat_ids = ArrayHelper::toInteger($tmp_cat_ids);
                                    $tmp_cat_ids = implode(',', $tmp_cat_ids);

                                    if (strpos($tmp_cat_ids, ','))
                                    {
                                            $addWhereClause .= ' and m.catid IN ('.$tmp_cat_ids.')';
                                    }
                                    else
                                    {
                                            $addWhereClause .= ' and m.catid = '.(int)$tmp_cat_ids;
                                    }
                            }
                            // tag search is not as usual
                            if ($taglistid != "")
                            {
                                    $tmp_tag_ids = explode(',', str_replace(';',',', $taglistid));                                       
                                    $tmp_tag_ids = ArrayHelper::toInteger($tmp_tag_ids);
                                    $tmp_tag_ids = implode(',', $tmp_tag_ids);                         
                                    if (strpos($tmp_tag_ids, ','))
                                    {
                                        $addWherePlacemarkTag = ' and tagmap.tag_id IN ('.$tmp_tag_ids.')';                         
                                    }
                                    else
                                    {
                                        $addWherePlacemarkTag = ' and tagmap.tag_id = '. (int) $tmp_tag_ids;                                              
                                    }

                                    $addWherePlacemarkTagExist = ' AND EXISTS (SELECT 1 FROM #__contentitem_tag_map AS tagmap '.
                                                                 ' WHERE tagmap.content_item_id = m.id '.
                                                                 ' AND tagmap.type_alias = \'com_zhosmmap.mapmarker\''.$addWherePlacemarkTag.')';    

                                    $addWhereClause .= $addWherePlacemarkTagExist;        
                            }
                    }
            }


            $nowDate = $db->Quote(Factory::getDate()->toSQL());

            // Remove 'h.published=1 and m.published=1
            // because group may be disabled, but manual edit users placemark enable

            if ((int)$markergroupctlmarker == 1)
            {
                    if ((int)$markergroupctlpath != 0)
                    {
                            $addWhereClause .= ' and (m.publish_up IS NULL OR m.publish_up <= ' . $nowDate . ')';
                            $addWhereClause .= ' and (m.publish_down IS NULL OR m.publish_down >= ' . $nowDate . ')';

                            $addWhereClausePath .= ' and (p.publish_up IS NULL OR p.publish_up <= ' . $nowDate . ')';
                            $addWhereClausePath .= ' and (p.publish_down IS NULL OR p.publish_down >= ' . $nowDate . ')';
                            $addWhereClausePath .= ' and (p.published = 1)';

                            // new parameters - start
                            //$addWhereClausePathPath .= ' and (p.mapid = '.(int)$id.')';

                            if ($pathlistid == ""
                             && $grouplistpathid == ""
                             && $categorylistpathid == ""
                             && $pathtaglistid == ""
                            )
                            {

                                    $addWhereClausePath .= ' and p.mapid='.(int)$id;

                                    if ($expathlistid != "")
                                    {
                                            $tmp_expl_ids = explode(',', str_replace(';',',', $expathlistid));                                       
                                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                                            if (strpos($tmp_expl_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.id NOT IN ('.$tmp_expl_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.id != '.(int)$tmp_expl_ids;
                                            }
                                    }
                            }
                            else
                            {
                                    if ($pathlistid != "")
                                    {
                                            $tmp_pl_ids = explode(',', str_replace(';',',', $pathlistid));                                       
                                            $tmp_pl_ids = ArrayHelper::toInteger($tmp_pl_ids);
                                            $tmp_pl_ids = implode(',', $tmp_pl_ids);

                                            if (strpos($tmp_pl_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.id IN ('.$tmp_pl_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.id = '.(int)$tmp_pl_ids;
                                            }
                                    }
                                    if ($expathlistid != "")
                                    {
                                            $tmp_expl_ids = explode(',', str_replace(';',',', $expathlistid));                                       
                                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                                            if (strpos($tmp_expl_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.id NOT IN ('.$tmp_expl_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.id != '.(int)$tmp_expl_ids;
                                            }
                                    }
                                    if ($grouplistpathid != "")
                                    {
                                            $tmp_grp_ids = explode(',', str_replace(';',',', $grouplistpathid));                                       
                                            $tmp_grp_ids = ArrayHelper::toInteger($tmp_grp_ids);
                                            $tmp_grp_ids = implode(',', $tmp_grp_ids);

                                            if (strpos($tmp_grp_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.markergroup IN ('.$tmp_grp_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.markergroup = '.(int)$tmp_grp_ids;
                                            }
                                    }
                                    if ($categorylistpathid != "")
                                    {
                                            $tmp_cat_ids = explode(',', str_replace(';',',', $categorylistpathid));                                       
                                            $tmp_cat_ids = ArrayHelper::toInteger($tmp_cat_ids);
                                            $tmp_cat_ids = implode(',', $tmp_cat_ids);

                                            if (strpos($tmp_cat_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.catid IN ('.$tmp_cat_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.catid = '.(int)$tmp_cat_ids;
                                            }
                                    }
                                    // tag search is not as usual
                                    if ($pathtaglistid != "")
                                    {
                                            $tmp_tag_ids = explode(',', str_replace(';',',', $pathtaglistid));                                       
                                            $tmp_tag_ids = ArrayHelper::toInteger($tmp_tag_ids);
                                            $tmp_tag_ids = implode(',', $tmp_tag_ids);                         
                                            if (strpos($tmp_tag_ids, ','))
                                            {
                                                $addWherePathTag = "\n" . ' and tagmap.tag_id IN ('.$tmp_tag_ids.')';                         
                                            }
                                            else
                                            {
                                                $addWherePathTag = "\n" . ' and tagmap.tag_id = '. (int) $tmp_tag_ids;                                              
                                            }

                                            $addWherePathTagExist = ' AND EXISTS (SELECT 1 FROM #__contentitem_tag_map AS tagmap '.
                                                                    ' WHERE tagmap.content_item_id = p.id '.
                                                                    ' AND tagmap.type_alias = \'com_zhosmmap.mappath\''.$addWherePathTag.')';    

                                            $addWhereClausePath .= $addWherePathTagExist;        
                                    }
                            }

                            // new parameters - end

                            if ((int)$markergroupctlpath == 1)
                            {
                                    $addWhereClausePath .= ' and (p.kmllayer IS NOT NULL and p.kmllayer != \'\')';
                            }
                            else if ((int)$markergroupctlpath == 2)
                            {
                                    $addWhereClausePath .= ' and ((p.path IS NOT NULL and p.path != \'\') or (p.data_id !=0))';
                            }
                            else if ((int)$markergroupctlpath == 3)
                            {
                                    $addWhereClausePath .= ' and ((p.path IS NOT NULL and p.path != \'\')  or (p.data_id !=0) or (p.kmllayer IS NOT NULL and p.kmllayer != \'\'))';
                            }
                            else 
                            {
                                    $addWhereClausePath .= ' and (1=2)';
                            }


                            $query->select('h.*, c.title as category, c.parent_id as catcatid ')
                                    ->from('#__zhosmmaps_markergroups as h')
                                    ->leftJoin('#__categories as c ON h.catid=c.id')
                                    ->where('( EXISTS (SELECT 1 FROM #__zhosmmaps_markers as m WHERE m.markergroup=h.id ' . $addWhereClause. ')'.
                                    ' or EXISTS (SELECT 1 FROM #__zhosmmaps_paths as p WHERE p.markergroup=h.id ' . $addWhereClausePath.'))')
                                    ;
                    }
                    else
                    {
                            $addWhereClause .= ' and (m.publish_up IS NULL OR m.publish_up <= ' . $nowDate . ')';
                            $addWhereClause .= ' and (m.publish_down IS NULL OR m.publish_down >= ' . $nowDate . ')';

                            $query->select('h.*, c.title as category, c.parent_id as catcatid ')
                                    ->from('#__zhosmmaps_markergroups as h')
                                    ->leftJoin('#__categories as c ON h.catid=c.id')
                                    ->where('EXISTS (SELECT 1 FROM #__zhosmmaps_markers as m WHERE m.markergroup=h.id ' . $addWhereClause.')')
                                    ;
                    }
            }
            else
            {
                    if ((int)$markergroupctlpath != 0)
                    {
                            $addWhereClausePath .= ' and (p.publish_up IS NULL OR p.publish_up <= ' . $nowDate . ')';
                            $addWhereClausePath .= ' and (p.publish_down IS NULL OR p.publish_down >= ' . $nowDate . ')';
                            $addWhereClausePath .= ' and (p.published = 1)';

                            // new parameters - start
                            //$addWhereClausePathPath .= ' and (p.mapid = '.(int)$id.')';

                            if ($pathlistid == ""
                             && $grouplistpathid == ""
                             && $categorylistpathid == ""
                             && $pathtaglistid == ""
                            )
                            {

                                    $addWhereClausePath .= ' and p.mapid='.(int)$id;

                                    if ($expathlistid != "")
                                    {
                                            $tmp_expl_ids = explode(',', str_replace(';',',', $expathlistid));                                       
                                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                                            if (strpos($tmp_expl_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.id NOT IN ('.$tmp_expl_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.id != '.(int)$tmp_expl_ids;
                                            }
                                    }
                            }
                            else
                            {
                                    if ($pathlistid != "")
                                    {
                                            $tmp_pl_ids = explode(',', str_replace(';',',', $pathlistid));                                       
                                            $tmp_pl_ids = ArrayHelper::toInteger($tmp_pl_ids);
                                            $tmp_pl_ids = implode(',', $tmp_pl_ids);

                                            if (strpos($tmp_pl_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.id IN ('.$tmp_pl_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.id = '.(int)$tmp_pl_ids;
                                            }
                                    }
                                    if ($expathlistid != "")
                                    {
                                            $tmp_expl_ids = explode(',', str_replace(';',',', $expathlistid));                                       
                                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                                            if (strpos($tmp_expl_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.id NOT IN ('.$tmp_expl_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.id != '.(int)$tmp_expl_ids;
                                            }
                                    }
                                    if ($grouplistpathid != "")
                                    {
                                            $tmp_grp_ids = explode(',', str_replace(';',',', $grouplistpathid));                                       
                                            $tmp_grp_ids = ArrayHelper::toInteger($tmp_grp_ids);
                                            $tmp_grp_ids = implode(',', $tmp_grp_ids);

                                            if (strpos($tmp_grp_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.markergroup IN ('.$tmp_grp_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.markergroup = '.(int)$tmp_grp_ids;
                                            }
                                    }
                                    if ($categorylistpathid != "")
                                    {
                                            $tmp_cat_ids = explode(',', str_replace(';',',', $categorylistpathid));                                       
                                            $tmp_cat_ids = ArrayHelper::toInteger($tmp_cat_ids);
                                            $tmp_cat_ids = implode(',', $tmp_cat_ids);

                                            if (strpos($tmp_cat_ids, ','))
                                            {
                                                    $addWhereClausePath .= ' and p.catid IN ('.$tmp_cat_ids.')';
                                            }
                                            else
                                            {
                                                    $addWhereClausePath .= ' and p.catid = '.(int)$tmp_cat_ids;
                                            }
                                    }
                                    // tag search is not as usual
                                    if ($pathtaglistid != "")
                                    {
                                            $tmp_tag_ids = explode(',', str_replace(';',',', $pathtaglistid));                                       
                                            $tmp_tag_ids = ArrayHelper::toInteger($tmp_tag_ids);
                                            $tmp_tag_ids = implode(',', $tmp_tag_ids);                         
                                            if (strpos($tmp_tag_ids, ','))
                                            {
                                                $addWherePathTag = "\n" . ' and tagmap.tag_id IN ('.$tmp_tag_ids.')';                         
                                            }
                                            else
                                            {
                                                $addWherePathTag = "\n" . ' and tagmap.tag_id = '. (int) $tmp_tag_ids;                                              
                                            }

                                            $addWherePathTagExist = ' AND EXISTS (SELECT 1 FROM #__contentitem_tag_map AS tagmap '.
                                                                    ' WHERE tagmap.content_item_id = p.id '.
                                                                    ' AND tagmap.type_alias = \'com_zhosmmap.mappath\''.$addWherePathTag.')';    

                                            $addWhereClausePath .= $addWherePathTagExist;        
                                    }
                            }

                            // new parameters - end

                            if ((int)$markergroupctlpath == 1)
                            {
                                    $addWhereClausePath .= ' and (p.kmllayer IS NOT NULL and p.kmllayer != \'\')';
                            }
                            else if ((int)$markergroupctlpath == 2)
                            {
                                    $addWhereClausePath .= ' and ((p.path IS NOT NULL and p.path != \'\')  or (p.data_id !=0))';
                            }
                            else if ((int)$markergroupctlpath == 3)
                            {
                                    $addWhereClausePath .= ' and ((p.path IS NOT NULL and p.path != \'\')  or (p.data_id !=0) or (p.kmllayer IS NOT NULL and p.kmllayer != \'\'))';
                            }
                            else 
                            {
                                    $addWhereClausePath .= ' and (1=2)';
                            }

                            $query->select('h.*, c.title as category, c.parent_id as catcatid ')
                                    ->from('#__zhosmmaps_markergroups as h')
                                    ->leftJoin('#__categories as c ON h.catid=c.id')
                                    ->where('EXISTS (SELECT 1 FROM #__zhosmmaps_paths as p WHERE p.markergroup=h.id ' . $addWhereClausePath.')')
                                    ;
                    }
                    else
                    {
                            // return nothing
                            $query->select(' h.*, c.title as category, c.parent_id as catcatid ')
                                    ->from('#__zhosmmaps_markergroups as h')
                                    ->leftJoin('#__categories as c ON h.catid=c.id')
                                    ->where('1=2')
                                    ;
                    }
            }

            if ((int)$markergroupshowicon == 50
             || (int)$markergroupshowicon == 51
             || (int)$markergroupshowicon == 52
             || (int)$markergroupshowicon == 55
            )
            {
                if ((int)$markergrouporder == 0)
                {
                    $query->order('c.title, h.title');
                }
                else if ((int)$markergrouporder == 1)
                {
                    $query->order('c.title, h.ordering');
                }
                else if ((int)$markergrouporder == 2)
                {
                    $query->order('c.title, h.title');
                }
                else if ((int)$markergrouporder == 10)
                {
                    $query->order('c.title, h.userorder, h.title');
                }
                else 
                {
                    $query->order('c.title, h.title');
                }
            }
            else
            {
                if ((int)$markergrouporder == 0)
                {
                    $query->order('h.title');
                }
                else if ((int)$markergrouporder == 1)
                {
                    $query->order('c.title, h.ordering');
                }
                else if ((int)$markergrouporder == 2)
                {
                    $query->order('c.title, h.title');
                }
                else if ((int)$markergrouporder == 10)
                {
                    $query->order('h.userorder, h.title');
                }
                else 
                {
                    $query->order('h.title');
                }
            }

            $db->setQuery($query);        

            // MarkerGroups
            $markergroups_manage = $db->loadObjectList();


            return $markergroups_manage;
    }


    
    public static function getPaths($id, 
                                    $pathlistid, $expathlistid, $grouplistid, $categorylistid, $pathtaglistid) 
    {
            $db = Factory::getDBO();

            $query = $db->getQuery(true);
            
            $addWhereClause = '';

            if ($pathlistid == ""
             && $grouplistid == ""
             && $categorylistid == ""
             && $pathtaglistid == ""
            )
            {

                    $addWhereClause .= ' and h.mapid='.(int)$id;

                    if ($expathlistid != "")
                    {
                            $tmp_expl_ids = explode(',', str_replace(';',',', $expathlistid));                                       
                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                            if (strpos($tmp_expl_ids, ','))
                            {
                                    $addWhereClause .= ' and h.id NOT IN ('.$tmp_expl_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.id != '.(int)$tmp_expl_ids;
                            }
                    }
            }
            else
            {
                    if ($pathlistid != "")
                    {
                            $tmp_pl_ids = explode(',', str_replace(';',',', $pathlistid));                                       
                            $tmp_pl_ids = ArrayHelper::toInteger($tmp_pl_ids);
                            $tmp_pl_ids = implode(',', $tmp_pl_ids);

                            if (strpos($tmp_pl_ids, ','))
                            {
                                    $addWhereClause .= ' and h.id IN ('.$tmp_pl_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.id = '.(int)$tmp_pl_ids;
                            }
                    }
                    if ($expathlistid != "")
                    {
                            $tmp_expl_ids = explode(',', str_replace(';',',', $expathlistid));                                       
                            $tmp_expl_ids = ArrayHelper::toInteger($tmp_expl_ids);
                            $tmp_expl_ids = implode(',', $tmp_expl_ids);

                            if (strpos($tmp_expl_ids, ','))
                            {
                                    $addWhereClause .= ' and h.id NOT IN ('.$tmp_expl_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.id != '.(int)$tmp_expl_ids;
                            }
                    }
                    if ($grouplistid != "")
                    {
                            $tmp_grp_ids = explode(',', str_replace(';',',', $grouplistid));                                       
                            $tmp_grp_ids = ArrayHelper::toInteger($tmp_grp_ids);
                            $tmp_grp_ids = implode(',', $tmp_grp_ids);

                            if (strpos($tmp_grp_ids, ','))
                            {
                                    $addWhereClause .= ' and h.markergroup IN ('.$tmp_grp_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.markergroup = '.(int)$tmp_grp_ids;
                            }
                    }
                    if ($categorylistid != "")
                    {
                            $tmp_cat_ids = explode(',', str_replace(';',',', $categorylistid));                                       
                            $tmp_cat_ids = ArrayHelper::toInteger($tmp_cat_ids);
                            $tmp_cat_ids = implode(',', $tmp_cat_ids);

                            if (strpos($tmp_cat_ids, ','))
                            {
                                    $addWhereClause .= ' and h.catid IN ('.$tmp_cat_ids.')';
                            }
                            else
                            {
                                    $addWhereClause .= ' and h.catid = '.(int)$tmp_cat_ids;
                            }
                    }
                    // tag search is not as usual
                    if ($pathtaglistid != "")
                    {
                            $tmp_tag_ids = explode(',', str_replace(';',',', $pathtaglistid));                                       
                            $tmp_tag_ids = ArrayHelper::toInteger($tmp_tag_ids);
                            $tmp_tag_ids = implode(',', $tmp_tag_ids);                         
                            if (strpos($tmp_tag_ids, ','))
                            {
                                $addWherePathTag = "\n" . ' and tagmap.tag_id IN ('.$tmp_tag_ids.')';                         
                            }
                            else
                            {
                                $addWherePathTag = "\n" . ' and tagmap.tag_id = '. (int) $tmp_tag_ids;                                              
                            }

                            $addWherePathTagExist = ' AND EXISTS (SELECT 1 FROM #__contentitem_tag_map AS tagmap '.
                                                    ' WHERE tagmap.content_item_id = h.id '.
                                                    ' AND tagmap.type_alias = \'com_zhosmmap.mappath\''.$addWherePathTag.')';    

                            $addWhereClause .= $addWherePathTagExist;        
                    }
            }
            
            $query->select('h.*, '.
                    ' c.title as category, g.icontype as groupicontype, g.overridemarkericon as overridemarkericon, g.published as publishedgroup, g.markermanagerminzoom as markermanagerminzoom, g.markermanagermaxzoom as markermanagermaxzoom, g.activeincluster as activeincluster, '.
                    ' g.iconofsetx as groupiconofsetx, g.iconofsety as groupiconofsety')
                ->from('#__zhosmmaps_paths as h')
                ->leftJoin('#__categories as c ON h.catid=c.id')
                ->leftJoin('#__zhosmmaps_markergroups as g ON h.markergroup=g.id')
                ->where('h.published=1'.$addWhereClause);
            
            $db->setQuery($query);        
            
            // Paths
            $mappaths = $db->loadObjectList();


            return $mappaths;
    }

    public static function getMapTypes() 
    {
            $db = Factory::getDBO();

            $query = $db->getQuery(true);
            $query->select('h.*, c.title as category ')
                ->from('#__zhosmmaps_maptypes as h')
                ->leftJoin('#__categories as c ON h.catid=c.id')
                ->where('h.published=1');
            $db->setQuery($query);        
            
            // Map Types
            $maptypes = $db->loadObjectList(); 


            return $maptypes;
    }

    
    public static function getCompatibleMode() 
    {
            // Get global params
            $app = Factory::getApplication();
            $comparams = ComponentHelper::getParams( 'com_zhosmmap' );
        
            $mapcompatiblemode = $comparams->get( 'map_compatiblemode');

            return $mapcompatiblemode;
    }

	public static function getLoadJQuery() 
    {
        // Get global params
        $app = Factory::getApplication();
        $comparams = ComponentHelper::getParams('com_zhosmmap');
		
		$loadjquery = $comparams->get( 'load_jquery', '' );

        return $loadjquery;
    }
	
    public static function getHttpsProtocol() 
    {
            // Get global params
            $app = Factory::getApplication();
            $comparams = ComponentHelper::getParams( 'com_zhosmmap' );
            $httpsprotocol = $comparams->get( 'httpsprotocol');

            return $httpsprotocol;
    }
    
    public static function getLoadType() 
    {
            // Get global params
            $app = Factory::getApplication();
            $comparams = ComponentHelper::getParams( 'com_zhosmmap' );
            $loadtype = $comparams->get( 'loadtype');

            return $loadtype;
    }
    
    public static function getMapAPIVersion() 
    {
            // Get global params
            $app = Factory::getApplication();
            $comparams = ComponentHelper::getParams( 'com_zhosmmap' );

            $mapapiversion = $comparams->get( 'map_api_version');

            return $mapapiversion;
    }

    public static function getDelay() 
    {
        // Get global params

        $app = Factory::getApplication();
        $comparams = ComponentHelper::getParams( 'com_zhosmmap' );
        
        $load_delay = $comparams->get( 'load_delay');

        return $load_delay;
    }
    
    public static function getMapLicenseInfo() 
    {
            // Get global params
            $app = Factory::getApplication();
            $comparams = ComponentHelper::getParams( 'com_zhosmmap' );

            $licenseinfo = $comparams->get( 'licenseinfo');

            return $licenseinfo;
    }

    
    public static function getPlacemarkTitleTag() 
    {
            // Get global params

            $app = Factory::getApplication();
            $comparams = ComponentHelper::getParams( 'com_zhosmmap' );

            $placemarktitletag = $comparams->get( 'placemarktitletag');

            return $placemarktitletag;
    }

    public static function getMarkerCoordinatesLatLngObject($markerId)
    {
            if ((int)$markerId != 0)
            {
                    $dbMrk = Factory::getDBO();

                    $queryMrk = $dbMrk->getQuery(true);
                    $queryMrk->select('h.*')
                            ->from('#__zhosmmaps_markers as h')
                            ->where('h.id = '.(int) $markerId);
                    $dbMrk->setQuery($queryMrk);        
                    $myMarker = $dbMrk->loadObject();

                    if (isset($myMarker))
                    {
                            if ($myMarker->latitude != "" && $myMarker->longitude != "")
                            {
                                    return 'new google.maps.LatLng('.$myMarker->latitude.', ' .$myMarker->longitude.')';
                            }
                            else
                            {
                                    return 'geocode';
                            }
                    }
                    else
                    {
                            return '';
                    }    
            }
    }    
        
        private static function getArticleMarkerExtraFields($article_id, $group_id)
        {
            $db = Factory::getDBO();

            $query = $db->getQuery(true);
            
            $query->select('f.id, f.title, fv.value')
                ->from('#__fields as f')
                ->innerJoin('#__fields_values as fv ON fv.field_id=f.id')
                ->where('f.state=1 '.
                        'AND f.context=\'com_content.article\' '.
                        'AND f.state=1 '.
                        'AND f.group_id='.(int)$group_id.' '.
                        'AND fv.item_id='.(int)$article_id
                        );
            $db->setQuery($query);       
            
            // Markers
            $extra_fields = $db->loadObjectList();
            
            /*
            if (isset($extra_fields) && !empty($extra_fields)) 
            {
                
            }
            */
            return $extra_fields;
        }
        
        public static function getArticleMarkers(
                    $offset_id,
                    $articlelistid,
                    $mapid,
                    $default_icontype,
                    $default_iconofsetx,
                    $default_iconofsety,
                    $icontype,
                    $iconofsetx,
                    $iconofsety,
                    $categorylistid,
                    $coordinategroup,
                    $latitude,
                    $longitude,
                    $markercontent,
                    $actionbyclick,
                    $baloon,
                    $showgps,
                    $toolbararticle
                ) 
        {
            $db = Factory::getDBO();

            $query = $db->getQuery(true);
            
            $addWhereClause = '';

            
            if ($categorylistid != "")
            {
                    $tmp_cat_ids = explode(',', str_replace(';',',', $categorylistid));                                       
                    $tmp_cat_ids = ArrayHelper::toInteger($tmp_cat_ids);
                    $tmp_cat_ids = implode(',', $tmp_cat_ids);

                    if (strpos($tmp_cat_ids, ','))
                    {
                            $addWhereClause .= ' and h.catid IN ('.$tmp_cat_ids.')';
                    }
                    else
                    {
                            $addWhereClause .= ' and h.catid = '.(int)$tmp_cat_ids;
                    }
            }
            
            if ($articlelistid != "")
            {
                    $tmp_a_ids = explode(',', str_replace(';',',', $articlelistid));                                       
                    $tmp_a_ids = ArrayHelper::toInteger($tmp_a_ids);
                    $tmp_a_ids = implode(',', $tmp_a_ids);

                    if (strpos($tmp_a_ids, ','))
                    {
                            $addWhereClause .= ' and h.id IN ('.$tmp_a_ids.')';
                    }
                    else
                    {
                            $addWhereClause .= ' and h.id = '.(int)$tmp_a_ids;
                    }
            }
            
            $query->select('h.id, h.title, h.id as articleid,'.
                    'fv1.value as latitude, fv2.value as longitude,'.
                    'g.id as article_extra_field_group')
                ->from('#__content as h, #__fields_groups as g ')
                ->innerJoin('#__fields as f1 ON f1.group_id=g.id')
                ->innerJoin('#__fields_values as fv1 ON fv1.field_id=f1.id')
                ->innerJoin('#__fields as f2 ON f2.group_id=g.id')
                ->innerJoin('#__fields_values as fv2 ON fv2.field_id=f2.id')
                ->where('h.state=1 '.
                        'AND g.context=\'com_content.article\' '.
                        'AND g.context=f1.context '.
                        'AND g.context=f2.context '.
                        'AND g.state=1 '.
                        'AND g.title='.$db->quote($coordinategroup).
                        'AND f1.state=1 '.
                        'AND f1.title='.$db->quote($latitude).
                        'AND fv1.item_id=h.id '.
                        'AND f2.state=1 '.
                        'AND f2.title='.$db->quote($longitude).
                        'AND fv2.item_id=h.id '.
                        $addWhereClause);
            $db->setQuery($query);       
            
            // Markers
            $markers = $db->loadObjectList();
            
            if (isset($markers) && !empty($markers)) 
            {
                    foreach ($markers as $key => $currentmarker) 
                    {
                        if ((int)$offset_id != 0)
                        {
                            $fix_id = (int)$offset_id;
                        }
                        else
                        {
                            $fix_id = 1;
                        }
                        $currentmarker->id = $fix_id * $currentmarker->id;
                        $currentmarker->actionbyclick = $actionbyclick;
                        $currentmarker->published = 1;
                        $currentmarker->markercontent = $markercontent;
                        $currentmarker->hrefsite = "";
                        $currentmarker->hrefsitename = "";
                        $currentmarker->mapid = $mapid;
                        $currentmarker->markergroup = 0;
                     
                        $currentmarker->baloon = $baloon;
                        
                        $currentmarker->showgps = $showgps;
                        $currentmarker->toolbararticle = $toolbararticle;
                        
                        // add optional fields
                        $extra_fields = MapDataHelper::getArticleMarkerExtraFields($currentmarker->articleid, $currentmarker->article_extra_field_group);
                        if (isset($extra_fields) && !empty($extra_fields)) 
                        {
                            foreach ($extra_fields as $key => $extra_field)
                            {
                                if ($extra_field->title == $icontype)
                                {
                                    $currentmarker->icontype = $extra_field->value;
                                }
                                else if ($extra_field->title == $iconofsetx)
                                {
                                    $currentmarker->iconofsetx = $extra_field->value;
                                }
                                else if ($extra_field->title == $iconofsety)
                                {
                                    $currentmarker->iconofsety = $extra_field->value;
                                }    
                                    
                            }
                        }
                        if (!isset($currentmarker->icontype) || $currentmarker->icontype == "")
                        {
                            $currentmarker->icontype = $default_icontype;
                        
                        }
                        if (!isset($currentmarker->iconofsetx) || $currentmarker->iconofsetx == "")
                        {
                            $currentmarker->iconofsetx = $default_iconofsetx;
                        
                        }
                        if (!isset($currentmarker->iconofsety) || $currentmarker->iconofsety == "")
                        {
                            $currentmarker->iconofsety = $default_iconofsety;
                        
                        }
                    }
            }


            return $markers;
        }


        
}
