<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive')
   ->useScript('form.validate');

$imgpath = URI::root() .'components/com_zhosmmap/assets/icons/';
$utilspath = URI::root() .'administrator/components/com_zhosmmap/assets/utils/';
  

$urlProtocol = "http";
if ($this->httpsprotocol != "")
{
    if ((int)$this->httpsprotocol == 0)
    {
        $urlProtocol = 'https';
    }
}

$document = Factory::getDocument();

?>
<form action="<?php echo Route::_('index.php?option=com_zhosmmap&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-validate">

<div class="main-card">

    <?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', ['active' => 'details', 'recall' => true, 'breakpoint' => 768]); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'details', Text::_('COM_ZHOSMMAP_VISUAL_STRUCT_DETAIL')); ?>
    <div class="row" id="tab1">
        <fieldset class="adminform">
                <?php foreach($this->form->getFieldset('details') as $field): ?>
                <div class="control-group">
                    <?php 
                        if ($field->id == 'jform_ordering')
                        {
                        }
                        else
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        ?>
                </div>
                <?php endforeach; ?>

            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>
        
    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'columns_props', Text::_('COM_ZHOSMMAP_VISUAL_STRUCT_COLUMNS')); ?>
    <div class="row" id="tab2">
        <fieldset class="adminform">
                <?php foreach($this->form->getFieldset('columns_props') as $field): ?>
                <div class="control-group">
                    <?php 

                            ?>
                            <div class="control-label">
                            <?php 
                                    echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                    echo $field->input;
                            ?>
                            </div>
                            <?php 

                    ?>
                </div>
                <?php endforeach; ?>

            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'lines', Text::_('COM_ZHOSMMAP_VISUAL_STRUCT_LINE_PROPS')); ?>
    <div class="row" id="tab3">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('lines') as $field): ?>
                <div class="control-group">
                    <?php 
                        if ($field->id == 'jform_start_icontype')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 


                                $iconTypeJS = " onchange=\"javascript:
                                if (document.forms.adminForm.jform_start_icontype.options[selectedIndex].value!='') 
                                {document.start_image.src='".$imgpath."' + document.forms.adminForm.jform_start_icontype.options[selectedIndex].value.replace(/#/g,'%23') + '.png'}
                                else 
                                {document.start_image.src=''}\"";


                                $scriptPosition = ' name=';

                                echo str_replace($scriptPosition, $iconTypeJS.$scriptPosition, $field->input);
                                echo '<img name="start_image" src="'.$imgpath .str_replace("#", "%23", $this->item->start_icontype).'.png" alt="" />';

                                echo '<div class="clr"></div>';
                                echo '<a class="btn btn-primary" href="'.$urlProtocol.'://wiki.zhuk.cc/index.php?title=Zh_OpenStreetMap_Credits_Icons" target="_blank">'.Text::_( 'COM_ZHOSMMAP_MAP_TERMSOFUSE_ICONS' ).' <img src="'.$utilspath.'info.png" alt="'.Text::_( 'COM_ZHOSMMAP_MAP_TERMSOFUSE_ICONS' ).'" style="margin: 0;" /></a>';
                                echo '<div class="clr"></div>';
                                echo '<br />';
                            ?>
                            </div>
                        <?php 
                        }
                        else if ($field->id == 'jform_end_icontype')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 


                                $iconTypeJS = " onchange=\"javascript:
                                if (document.forms.adminForm.jform_end_icontype.options[selectedIndex].value!='') 
                                {document.end_image.src='".$imgpath."' + document.forms.adminForm.jform_end_icontype.options[selectedIndex].value.replace(/#/g,'%23') + '.png'}
                                else 
                                {document.end_image.src=''}\"";


                                $scriptPosition = ' name=';

                                echo str_replace($scriptPosition, $iconTypeJS.$scriptPosition, $field->input);
                                echo '<img name="end_image" src="'.$imgpath .str_replace("#", "%23", $this->item->end_icontype).'.png" alt="" />';

                                echo '<div class="clr"></div>';
                                echo '<a class="btn btn-primary" href="'.$urlProtocol.'://wiki.zhuk.cc/index.php?title=Zh_OpenStreetMap_Credits_Icons" target="_blank">'.Text::_( 'COM_ZHOSMMAP_MAP_TERMSOFUSE_ICONS' ).' <img src="'.$utilspath.'info.png" alt="'.Text::_( 'COM_ZHOSMMAP_MAP_TERMSOFUSE_ICONS' ).'" style="margin: 0;" /></a>';
                                echo '<div class="clr"></div>';
                                echo '<br />';
                            ?>
                            </div>
                        <?php 
                        }
                        else if ($field->id == 'jform_start_descriptionhtml' || $field->id == 'jform_end_descriptionhtml')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        else
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>   
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.endTabSet'); ?>

</div>


<div class="row-fluid">
    <input type="hidden" name="task" value="visualstruct.edit" />
    <?php echo HTMLHelper::_('form.token'); ?>
</div>



</form>


