<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive')
   ->useScript('form.validate');

$document = Factory::getDocument();

// Map Types
$maptypes = $this->mapTypeList;

$current_custom_js_path = URI::root() .'components/com_zhosmmap/assets/js/';

$urlProtocol = "http";
if ($this->httpsprotocol != "")
{
    if ((int)$this->httpsprotocol == 0)
    {
        $urlProtocol = 'https';
    }
}

if ($this->map_height != "")
{
    if ((int)$this->map_height == 0)
    {
        $map_height = "420px";
        $map_height_wrap = "450px";
    }
    else
    {
        $map_height = ((int)$this->map_height - 30) . "px";
        $map_height_wrap = (int)$this->map_height . "px";
    }
}
else 
{
    $map_height = "420px";
    $map_height_wrap = "450px";
}


//$mainScriptBegin = $current_custom_js_path . 'leaflet/';
$mainScriptBegin = "https://unpkg.com/leaflet";

$mainScriptMiddle = "";

$mainScriptEnd = "/dist/leaflet";

if ($this->mapapiversion != "")
{
    $mainScriptMiddle = $this->mapapiversion;
}
 else 
{
    $mainScriptMiddle = '1.9.3';
}

$mainScriptMiddle = "@" . $mainScriptMiddle;


$mainScriptBegin .= $mainScriptMiddle;


$mainScript = $mainScriptBegin . $mainScriptEnd;

if ((int) $this->item->id != 0)
{
    $flg_show_map = false;
}
else
{
    $flg_show_map = true;
}

$wa->registerAndUseStyle('zhosmmaps.mappath_main.style', $mainScript . '.css');
$wa->registerAndUseScript('zhosmmaps.mapmarker_main.script', $mainScript . '.js');


?>
<form action="<?php echo Route::_('index.php?option=com_zhosmmap&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-validate">

<div class="main-card">

    <?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', ['active' => 'pathmain', 'recall' => true, 'breakpoint' => 768]); ?>
    
    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'pathmain', Text::_('COM_ZHOSMMAP_MAPPATH_PATH')); ?>
    <div class="row" id="tab0">
        <div>
            <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('pathmain') as $field): ?>
                    
                    
                    <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                    </div>


                <?php endforeach; ?>
            
            </fieldset>
        
            <div>
                    <div>
                    <?php if (!$flg_show_map) { ?>
                    <button id="zhosm-display-map" class="btn btn-primary" type="button" onclick="document.getElementById('mapDivWrapper').style.display = 'block';initializeMap();document.getElementById('zhosm-display-map').style.display = 'none';"><?php echo Text::_('COM_ZHOSMMAP_MAP_SHOW_MAP_BUTTON'); ?></button>
                    <?php } ?>
                    </div>   
                    
                    <div id="mapDivWrapper" style="margin:0;padding:0;width:100%;height:<?php echo $map_height_wrap ?>">

                    <div id="OMapsID" style="margin:0;padding:0;width:100%;height:<?php echo $map_height ?>">

                
                    <?php 

                    $wa->registerAndUseStyle('zhosmmaps.mappath.style', URI::root() .'administrator/components/com_zhosmmap/assets/css/admin.css');

                    $mapDefLat = $this->mapDefLat;
                    $mapDefLng = $this->mapDefLng;


                    $mapMapTypeCustom = $this->mapMapTypeCustom;


                    //Script begin
                    $scripttext = '<script type="text/javascript" >//<![CDATA[' ."\n";


                        $scripttext .= 'var initialLocation;' ."\n";
                        $scripttext .= 'var spblocation;' ."\n";
                        $scripttext .= 'var browserSupportFlag =  new Boolean();' ."\n";
                        $scripttext .= 'var map;' ."\n";
                        $scripttext .= 'var marker;' ."\n";


                        $scripttext .= 'function initializeMap() {' ."\n";

                                                
                        
                        if ($mapDefLat != "" && $mapDefLng !="")
                        {
                            $scripttext .= 'spblocation = L.latLng('.$mapDefLat.', '.$mapDefLng.');' ."\n";
                        }
                        else
                        {
                            $scripttext .= 'spblocation = L.latLng(59.9388, 30.3158);' ."\n";
                        }

                        $scripttext .= 'var myOptions = {' ."\n";
                        $scripttext .= '    zoom: 14,' ."\n";                            
                                                    $scripttext .= '      scrollWheelZoom: false,' ."\n";    
                        $scripttext .= '      zoomControl: true' ."\n";
                        $scripttext .= '  };' ."\n";


                        $scripttext .= '    map = L.map("OMapsID", myOptions);' ."\n";

                                                    $scripttext .= '    L.tileLayer(\'https://tile.openstreetmap.org/{z}/{x}/{y}.png\', {' ."\n";
                                                    $scripttext .= '        attribution: \'&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> '.Text::_('COM_ZHOSMMAP_MAP_CONTRIBUTORS').'\'' ."\n";
                                                    $scripttext .= '    }).addTo(map);' ."\n";                                                        
                                                    
                        if (isset($this->item->latitude) && isset($this->item->longitude) )
                        {
                            $scripttext .= 'initialLocation = L.latLng('.$this->item->latitude.', ' .$this->item->longitude.');' ."\n";
                            $scripttext .= '  map.setView(initialLocation, 14);' ."\n";

                            $scripttext .= '  marker = L.marker(initialLocation, {' ."\n";
                            $scripttext .= '      draggable:true ' ."\n";
                            $scripttext .= '}).addTo(map);'."\n";

                            $scripttext .= '    marker.on(\'drag\', function(event) {' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_longitude.value = event.latlng.lng;' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_latitude.value = event.latlng.lat;' ."\n";
                            $scripttext .= '    });' ."\n";
                            
                            $scripttext .= '    map.on(\'click\', function(event) {' ."\n";
                            $scripttext .= '    marker.setLatLng(event.latlng);' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_longitude.value = event.latlng.lng;' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_latitude.value = event.latlng.lat;' ."\n";
                            $scripttext .= '    });' ."\n";

                        }
                        else
                        {
                            $scripttext .= 'initialLocation = spblocation;' ."\n";
                            $scripttext .= '  map.setView(initialLocation, 14);' ."\n";

                            $scripttext .= '  marker = L.marker(initialLocation, {' ."\n";
                            $scripttext .= '      draggable:true ' ."\n";
                            $scripttext .= '}).addTo(map);'."\n";

                            $scripttext .= '    marker.on(\'drag\', function(event) {' ."\n";
                            $scripttext .= '    document.forms.adminForm.jform_helpitem.value = event.latlng.lat + "," + event.latlng.lng;' ."\n";
                            $scripttext .= '    });' ."\n";
                            
                            $scripttext .= '    map.on(\'click\', function(event) {' ."\n";
                            $scripttext .= '    marker.setLatLng(event.latlng);' ."\n";                                                               
                            $scripttext .= '    document.forms.adminForm.jform_helpitem.value = event.latlng.lat + "," + event.latlng.lng;' ."\n";
                            $scripttext .= '    });' ."\n";
                                                        
                                                            
                            $scripttext .= '    map.setView(initialLocation, 14);' ."\n";
                                                            $scripttext .= '    marker.setLatLng(initialLocation);' ."\n";
                                                            
                                                            if ((int)$this->item->id == 0
                                                             || ( $this->item->path == ""
                                                               && $this->item->kmllayer == ""     
                                                               && $this->item->imgurl == ""     
                                                               && $this->item->gridtilefunc == ""
                                                               && (int)$this->item->data_id == 0)
                                                            )
                                                            {
                                $scripttext .= '      // Try W3C Geolocation method (Preferred)' ."\n";
                                $scripttext .= '      if(navigator.geolocation) {' ."\n";
                                $scripttext .= '        browserSupportFlag = true;' ."\n";
                                $scripttext .= '        navigator.geolocation.getCurrentPosition(function(position) {' ."\n";
                                $scripttext .= '          initialLocation = L.latLng(position.coords.latitude,position.coords.longitude);' ."\n";
                                                                    $scripttext .= '    map.setView(initialLocation, 14);' ."\n";
                                                                    $scripttext .= '    marker.setLatLng(initialLocation);' ."\n";
                                $scripttext .= '        }, function() {' ."\n";
                                $scripttext .= '          handleNoGeolocation(browserSupportFlag);' ."\n";
                                $scripttext .= '        });' ."\n";
                                $scripttext .= '      } else {' ."\n";
                                $scripttext .= '        // Browser doesn\'t support Geolocation' ."\n";
                                $scripttext .= '        browserSupportFlag = false;' ."\n";
                                $scripttext .= '        handleNoGeolocation(browserSupportFlag);' ."\n";
                                $scripttext .= '      }' ."\n";
                                                            }
                        }


                    // end initialize    
                    $scripttext .= '};' ."\n";

                    $scripttext .= 'function handleNoGeolocation(errorFlag) {' ."\n";
                    $scripttext .= '  if (errorFlag == true) {' ."\n";
                    $scripttext .= '    initialLocation = spblocation;' ."\n";
                    //$scripttext .= '    contentString = "Error: The Geolocation service failed.";' ."\n";
                    $scripttext .= '  } else {' ."\n";
                    $scripttext .= '    initialLocation = spblocation;' ."\n";
                    //$scripttext .= '    contentString = "Error: Your browser doesn\'t support geolocation.";' ."\n";
                    $scripttext .= '  }' ."\n";
                    $scripttext .= '  map.setView(initialLocation, 14);' ."\n";
                    $scripttext .= '  marker.setLatLng(initialLocation);' ."\n";
                                            
                    // end initialize
                    $scripttext .= '};' ."\n";


                    $scripttext .= ' function addLoadEvent(func) {' ."\n";
                    $scripttext .= '  var oldonload = window.onload;' ."\n";
                    $scripttext .= '  if (typeof window.onload != \'function\') {' ."\n";
                    $scripttext .= '    window.onload = func;' ."\n";
                    $scripttext .= '  } else {' ."\n";
                    $scripttext .= '    window.onload = function() {' ."\n";
                    $scripttext .= '      if (oldonload) {' ."\n";
                    $scripttext .= '        oldonload();' ."\n";
                    $scripttext .= '      }' ."\n";
                    $scripttext .= '      func();' ."\n";
                    $scripttext .= '    }' ."\n";
                    $scripttext .= '  }' ."\n";
                    $scripttext .= '}    ' ."\n";    

                    if ($flg_show_map)
                    {
                        $scripttext .= 'document.getElementById("mapDivWrapper").style.display = "block";' ."\n";
                        $scripttext .= 'addLoadEvent(initializeMap);' ."\n";
                    }
                    else
                    {
                        $scripttext .= 'document.getElementById("mapDivWrapper").style.display = "none";' ."\n";
                    }
                        
                    $scripttext .= '//]]></script>' ."\n";
                    // Script end


                    echo $scripttext;



                    ?>
                    </div>


                    <?php
                        $credits ='<div>'."\n";

                        $credits .='</div>'."\n";
                    echo $credits;
                    ?>

                </div>

            </div>
        </div>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'details', Text::_('COM_ZHOSMMAP_MAPPATH_DETAIL')); ?>
    <div class="row" id="tab1">
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('details') as $field): ?>
                <div class="control-group">
                    <?php 
                        if ($field->id == 'jform_descriptionhtml')
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        else
                        {
                            ?>
                            <div class="control-label">
                            <?php 
                                echo $field->label;
                            ?>
                            </div>
                            <div class="controls">
                            <?php 
                                echo $field->input;
                            ?>
                            </div>
                            <?php 
                        }
                        ?>
                </div>
                <?php endforeach; ?>

            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'pathwithlabel', Text::_('COM_ZHOSMMAP_MAPPATH_DETAIL_WITHLABEL')); ?>
    <div class="row" id="tab7">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('pathwithlabel') as $field): ?>
                <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'pathadvanced', Text::_('COM_ZHOSMMAP_MAPPATH_PATHADVANCED')); ?>
    <div class="row" id="tab2">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('pathadvanced') as $field): ?>
                <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>
    
    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'kmloptions', Text::_('COM_ZHOSMMAP_MAPPATH_DETAIL_KMLLAYER_TITLE')); ?>
    <div class="row" id="tab3">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('kmloptions') as $field): ?>
                <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>
    
    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'elevationdata', Text::_('COM_ZHOSMMAP_MAPPATH_DETAIL_ELEVATION')); ?>
    <div class="row" id="tab8">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('elevationdata') as $field): ?>
                <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>
    
    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'groundimage', Text::_('COM_ZHOSMMAP_MAPPATH_DETAIL_IMGGROUND_TITLE')); ?>
    <div class="row" id="tab5">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('groundimage') as $field): ?>
                <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>
    
    <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'gridlayer', Text::_('COM_ZHOSMMAP_MAPPATH_DETAIL_GRID_TITLE')); ?>
    <div class="row" id="tab6">
        
        <fieldset class="adminform">
            
                <?php foreach($this->form->getFieldset('gridlayer') as $field): ?>
                <div class="control-group">
                    <?php 
                        ?>
                        <div class="control-label">
                        <?php 
                            echo $field->label;
                        ?>
                        </div>
                        <div class="controls">
                        <?php 
                            echo $field->input;
                        ?>
                        </div>
                        <?php 
                    ?>
                </div>
                <?php endforeach; ?>
            
        </fieldset>
    </div>
    <?php echo HTMLHelper::_('uitab.endTab'); ?>

    <?php echo HTMLHelper::_('uitab.endTabSet'); ?>

</div>

<div class="row-fluid">
    <input type="hidden" name="task" value="mappath.edit" />
    <?php echo HTMLHelper::_('form.token'); ?>
</div>

</form>


