<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
// No direct access to this file
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;

$document    = Factory::getDocument();

$wa  = $document->getWebAssetManager();


if (isset($this->loadjquery))
{
	if ((int)$this->loadjquery == 1) {
		$wa->useScript('jquery');
	}
}

?>
<form action="<?php echo Route::_('index.php?option=com_zhosmmap&view=importzhyms'); ?>" method="post" name="adminForm" id="adminForm">

    <div class="row zhosm-form-container">

	<div class="col-md-12">
		<div id="j-main-container" class="j-main-container">
		
			<table class="table table-striped" id="importzhymList">
				<thead><?php echo $this->loadTemplate('head');?></thead>
				<tfoot><?php echo $this->loadTemplate('foot');?></tfoot>
				<tbody><?php echo $this->loadTemplate('body');?></tbody>
			</table>

                    <?php  
                    echo HTMLHelper::_(
            'bootstrap.renderModal',
            'ImportZhYMGroupModal',
            array(
                'title'       => Text::_('COM_ZHOSMMAP_UTILS_GROUP_CLONE'),
                'url'         => Route::_('index.php?option=com_zhosmmap&amp;view=uploadzhymgroup&amp;tmpl=component&amp;'. Session::getFormToken().'=1'),
                'height'      => '400px',
                'width'       => '300px',
                                'backdrop'    => 'static',
                                'closeButton' => false,
                                'modalWidth'  => '40',
                'footer'      => '<a class="btn" data-bs-dismiss="modal" type="button"'
                                                .' id="load_import_group_cancel"'
                        . ' onclick="jQuery(\'#ImportZhYMGroupModal iframe\').contents().find(\'#closeBtn\').click();jQuery(\'#load_import_group_do\').show();jQuery(\'#load_import_group_cancel\').html(\''.Text::_('COM_ZHOSMMAP_MAPBUFMRKS_CANCEL').'\');">'
                        . Text::_('COM_ZHOSMMAP_MAPBUFMRKS_CANCEL') . '</a>'
                        . '<button class="btn btn-success" type="button"'
                                                .' id="load_import_group_do"'
                        . ' onclick="jQuery(\'#ImportZhYMGroupModal iframe\').contents().find(\'#importBtn\').click();jQuery(\'#load_import_group_do\').hide();jQuery(\'#load_import_group_cancel\').html(\''.Text::_('COM_ZHOSMMAP_MAPBUFMRKS_CLOSE').'\');">'
                        . Text::_('COM_ZHOSMMAP_MAPBUFMRKS_IMPORT') . '</button>',
            )
                    ); 

                    echo HTMLHelper::_(
            'bootstrap.renderModal',
            'ImportZhYMPlacemarkModal',
            array(
                'title'       => Text::_('COM_ZHOSMMAP_UTILS_PLACEMARK_CLONE'),
                'url'         => Route::_('index.php?option=com_zhosmmap&amp;view=uploadzhymplacemark&amp;tmpl=component&amp;'. Session::getFormToken().'=1'),
                'height'      => '200px',
                'width'       => '300px',
                                'backdrop'    => 'static',
                                'closeButton' => false,
                                'modalWidth'  => '40',
                'footer'      => '<a class="btn" data-bs-dismiss="modal" type="button"'
                                                .' id="load_import_placemark_cancel"'
                        . ' onclick="jQuery(\'#ImportZhYMPlacemarkModal iframe\').contents().find(\'#closeBtn\').click();jQuery(\'#load_import_placemark_do\').show();jQuery(\'#load_import_placemark_cancel\').html(\''.Text::_('COM_ZHOSMMAP_MAPBUFMRKS_CANCEL').'\');">'
                        . Text::_('COM_ZHOSMMAP_MAPBUFMRKS_CANCEL') . '</a>'
                        . '<button class="btn btn-success" type="button"'
                                                .' id="load_import_placemark_do"'
                        . ' onclick="jQuery(\'#ImportZhYMPlacemarkModal iframe\').contents().find(\'#importBtn\').click();jQuery(\'#load_import_placemark_do\').hide();jQuery(\'#load_import_placemark_cancel\').html(\''.Text::_('COM_ZHOSMMAP_MAPBUFMRKS_CLOSE').'\');">'
                        . Text::_('COM_ZHOSMMAP_MAPBUFMRKS_IMPORT') . '</button>',
            )
                    ); 

                    
                ?>

			<div>
				<input type="hidden" name="task" value="" />
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
    </div>
</div>
    
</form>
