<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Administrator\View\Importzhyms;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Pagination\Pagination;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Registry\Registry;

use ZhukDL\Component\ZhOSMMap\Administrator\Helper\ZhosmmapHelper;
use ZhukDL\Component\ZhOSMMap\Administrator\Model\ImportzhymModel;

/**
 * View class for the ZhOSMMap ImportZhYM Component
 */
class HtmlView extends BaseHTMLView 
{
	

    // Overwriting JView display method
    function display($tpl = null): void
    {
		$this->loadjquery = ZhosmmapHelper::getLoadJQuery(); 
        
        $this->addToolBar();

        // Display the template
        parent::display($tpl);

        // Set the document
		/* 18.10.2023 for Joomla!4.4
        $this->setDocument();
		*/

    }

        function checkExistsExtension($extension) {

            $db = Factory::getDBO();

            $query = $db->getQuery(true);

            $query->select('1')
                ->from($db->quoteName('#__zh'.$extension.'maps_maps', 'h'))
            ;

            $db->setQuery($query);        

            try 
            {
                $groups = $db->loadObject();
                if (isset($groups) && !empty($groups)) 
                {
                    return 1;
                }
                else
                {
                    return 0;
                }

            }
            catch (Exception $e) 
            {
                return 0;
            }

        }
        
    /**
     * Setting the toolbar
     */
    protected function addToolBar() 
    {


        $canDo = ContentHelper::getActions('com_zhosmmap');
        ToolbarHelper::title(Text::_('COM_ZHOSMMAP_IMPORTZHYMS_MANAGER'), 'importzhym');
                
        $bar = Toolbar::getInstance('toolbar');                
		
		ToolbarHelper::custom('importzhym.back', 'exit.png', 'exit.png', Text::_('COM_ZHOSMMAP_UTILS_BUTTON_CLOSE'), false);
		
		if ($this->checkExistsExtension('yandex') != 0)
		{
			if ($canDo->get('core.create')) 
			{

				$bar->popupButton('box-add', Text::_('COM_ZHOSMMAP_UTILS_GROUP_CLONE'))
				      ->selector('ImportZhYMGroupModal')
					  ->listCheck(false);

			}
			
			if ($canDo->get('core.admin')) 
			{
				$bar->popupButton('box-add', Text::_('COM_ZHOSMMAP_UTILS_PLACEMARK_CLONE'))
				      ->selector('ImportZhYMPlacemarkModal')
					  ->listCheck(false);

				ToolbarHelper::divider();
			}
		}
              

		ToolbarHelper::custom('importzhym.marker_log', 'warning-2', 'warning-2', Text::_('COM_ZHOSMMAP_UTILITIES_IMPORT_LOG'), false);
        if ($canDo->get('core.admin')) 
        {
			ToolbarHelper::custom('importzhym.marker_delete_log', 'purge', 'purge', Text::_('COM_ZHOSMMAP_UTILITIES_IMPORT_LOG_DELETE'), false);
		}
		
		$help_url = 'http://wiki.zhuk.cc/index.php/Zh_OpenStreetMap_Description#Import_Zh_YandexMap';
		ToolbarHelper::help('', false, $help_url);

    }

    /**
     * Method to set up the document properties
     *
     * @return void
     */
	 /* 18.10.2023 for Joomla!4.4
    protected function setDocument() 
    {
        $document = Factory::getDocument();
        $document->setTitle(Text::_('COM_ZHOSMMAP_IMPORTZHYMS_ADMINISTRATION'));
    }
	*/

}
