<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Administrator\Table;

// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Application\ApplicationHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;
use Joomla\Database\ParameterType;
use Joomla\Registry\Registry;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Tag\TaggableTableInterface;
use Joomla\CMS\Tag\TaggableTableTrait;

class MapmarkerTable extends Table implements TaggableTableInterface
{
    use TaggableTableTrait;
    
    /**
	 * Indicates that columns fully support the NULL value in the database
	 *
	 * @var    boolean
	 * @since  4.0.0
	 */
    protected $_supportNullValue = true;
    
    /**
     * Constructor
     *
     * @param object Database connector object
     */
    function __construct(DatabaseDriver $db) 
    {
        $this->typeAlias = 'com_zhosmmap.mapmarker';
        
        parent::__construct('#__zhosmmaps_markers', 'id', $db);
        
        //TableObserverTags::createObserver($this, array('typeAlias' => 'com_zhosmmap.mapmarker'));
    }
    
    /**
     * Overloaded check function
     *
     * @return  boolean
     * @see     Table::check
     * @since   1.5
     */
    public function check()
    {

        // Set publish_up, publish_down to null if not set
		if (!$this->createddate)
		{
			$this->createddate = null;
		}

		if (!$this->contactid)
		{
			$this->contactid = 0;
		}
        
   		if (!$this->articleid)
		{
			$this->articleid = 0;
		}

		if (!$this->publish_down)
		{
			$this->publish_down = null;
		}

		if (!$this->publish_up)
		{
			$this->publish_up = null;
		}
		// Check the publish down date is not earlier than publish up.
		if (!is_null($this->publish_down) && !is_null($this->publish_up) && $this->publish_down < $this->publish_up)
		{
			$this->setError(Text::_('JGLOBAL_START_PUBLISH_AFTER_FINISH'));

			return false;
		}
        
        if ($this->latitude == "" 
         && $this->longitude == ""
         && (int)$this->data_id == 0
        )
        {
            $this->setError(Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL_COLUMNS_REQ'));
            return false;
        }
        else
        {
            if (($this->latitude != "" 
              && $this->longitude == "")
              ||($this->latitude == ""
              && $this->longitude != "")
            )
            {
                $this->setError(Text::_('COM_ZHOSMMAP_MAPMARKER_DETAIL_COLUMNS_LAT_LNG_ERROR'));
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * Overloaded bind function
     *
     * @param       array           named array
     * @return      null|string     null is operation was satisfactory, otherwise returns an error
     * @see Table:bind
     * @since 1.5
     */
    public function bind($array, $ignore = '') 
    {
        if (isset($array['params']) && is_array($array['params'])) 
        {
            // Convert the params field to a string.
            $parameter = new Registry;
            $parameter->loadArray($array['params']);
            $array['params'] = (string)$parameter;
        }
        return parent::bind($array, $ignore);
    }
 
    /**
     * Overriden Table::store to set modified data and user id.
     *
     * @param   boolean  $updateNulls  True to update fields even if they are null.
     *
     * @return  boolean  True on success.
     *
     * @since   3.1
     */
    public function store($updateNulls = true)
    {

        if ($this->id) {
        }
        else
        {

            $this->rating_value = 0;
            $this->rating_count = 0;            
            
        }
        
        return parent::store($updateNulls);
    }

    public function getTypeAlias()
	{
		return $this->typeAlias;
	}
    
}
