<?php
/*------------------------------------------------------------------------
# com_zhosmmap - Zh OpenStreetMap
# ------------------------------------------------------------------------
# author:    Dmitry Zhuk
# copyright: Copyright (C) 2011 zhuk.cc. All Rights Reserved.
# license:   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
# website:   http://zhuk.cc
# Technical Support Forum: http://forum.zhuk.cc/
-------------------------------------------------------------------------*/
namespace ZhukDL\Component\ZhOSMMap\Administrator\Controller;
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\GenericDataException;

use Joomla\CMS\MVC\Controller\FormController;

/**
 * ZhOSM ImportZhYM Controller
 */
class ImportzhgmController extends FormController
{
    
    public function marker_log()
    {
            // Check for request forgeries.
            Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));

            $model = $this->getModel();

            $return = $model->checkLog("google");
            
            if ($return == 0)
            {
                $this->setMessage(Text::_('COM_ZHOSMMAP_MAPBUFMRKS_LOG_NO_DATA_FOUND'));
                
                // Redirect to the list screen.
                $this->setRedirect(Route::_('index.php?option=com_zhosmmap&view=importzhgms', false));
            }
            else
            {
                // Redirect to the list screen.
                $this->setRedirect(Route::_('index.php?option=com_zhosmmap&view=importzhgmlogs', false));
            }

            

    }

    public function marker_delete_log()
    {
            // Check for request forgeries.
            Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));

            // Get the model
            $model = $this->getModel();

            $return = $model->deleteLog("google");
            
            if (!$return)
            {
				if (count($errors = $model->getErrors())) {
					throw new GenericDataException(implode("\n", $errors), 500);
				}
            }
            else
            {
                    $this->setMessage(Text::_('COM_ZHOSMMAP_MAPBUFMRKS_LOG_DELETED'));
            }

            $this->setRedirect(Route::_('index.php?option=com_zhosmmap&view=importzhgms', false));
            
    }      
               

    public function back()
    {
            // Check for request forgeries.
            Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));

            // Redirect to the list screen.
            $this->setRedirect(Route::_('index.php?option=com_zhosmmap&view=utils', false));

    }
    
    
}
