<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_admin
 *
 * @copyright   (C) 2009 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\Admin\Administrator\Service\HTML;

use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Utility class working with system
 *
 * @since  1.6
 */
class System
{
    /**
     * Method to generate a string message for a value
     *
     * @param   string  $val  a php ini value
     *
     * @return  string html code
     */
    public function server($val)
    {
        return !empty($val) ? $val : Text::_('COM_ADMIN_NA');
    }
}
